<?php


class cb_p6_a1_plugin extends cb_p6_a1_core
{
	public function plugin_construct()
	{
		
		// If Patreon_WordPress class is not found, drop a notice and exit.

		add_action( 'plugins_loaded', array(&$this, 'init'),60);
		add_action('admin_init', array(&$this, 'admin_init'));
		// Below admin_menu hook can be removed when relevant issue in plugin engine is fixed: 
		/*
		[admin_init] mustn't be placed in an admin_init action function, because the admin_init action is called after admin_menu - plugins have admin_menu in admin_init, hence its not firing
		*/
		add_action('admin_menu', array(&$this,'add_admin_menus'));
		
		if( $this->required_plugins() AND ( !isset( $this->internal['setup_is_being_done'] ) OR !$this->internal['setup_is_being_done'] ) ) {
			return;
		}
		
		// add_action('admin_init', array(&$this, 'check_requirements_and_setup'),0);
		
		// This is here to allow Patron Pro's lock_or_not function to override the check Patreon WordPress makes to see if a post has a $ level set before sending it to Patreon. This must be set to on to allow these overrides
		
		$GLOBALS['patreon_enable_direct_unlocks'] = true;
		
		
		add_action( 'admin_head', array(&$this,'add_visual_tinymce_button') );		
	
		add_action( 'admin_footer', array(&$this,'add_admin_modal') );

		add_filter( 'do_shortcode_tag',array(&$this,'filter_patreon_shortcodes'),PHP_INT_MAX,3);
				
		add_action( 'wp_login',array(&$this,'hook_into_login_process'),0,2);
		
		add_action( 'patreon_do_action_after_new_user_created_from_patreon_logged_in',array(&$this,'hook_into_patreon_user_creation_and_login_process'),0,1);
		add_action( 'patreon_do_action_after_user_logged_in_via_patreon',array(&$this,'hook_into_patreon_user_creation_and_login_process'),0,1);
	
		add_shortcode( 'ppp_patron_only', array($this, 'patron_only_shortcode') );
		add_shortcode( 'ppp_test', array($this, 'patron_test_shortcode') );
		add_shortcode( 'ppp_non_patron_only', array($this, 'non_patron_only_shortcode') );
		add_filter( 'ptrn/error_message', array($this, 'filter_patreon_messages'));
		
		add_action( 'upgrader_process_complete', array(&$this, 'upgrade'),10,2);
		
		// add_filter( 'the_content', array( &$this, 'gate_entire_content' ),PHP_INT_MAX );
		
		add_filter( 'the_content', array( &$this, 'preprocess_content' ),0, 1 );
		
		// add_filter( 'ptrn/override_interface_template', array( &$this, 'gate_entire_content' ), PHP_INT_MAX, 2 );
		add_filter( 'ptrn/override_content_filtering', array( &$this, 'gate_entire_content' ), PHP_INT_MAX, 2 );
		add_filter( 'ptrn/label_text_over_universal_button', array( &$this, 'filter_label_over_patreon_button' ), PHP_INT_MAX, 6 );
		add_filter( 'ptrn/label_text_under_universal_button', array( &$this, 'filter_label_under_patreon_button' ), PHP_INT_MAX, 7 );
		
		add_filter( 'ptrn/lock_or_not', array( &$this, 'lock_or_not' ), PHP_INT_MAX, 4 );
		
		add_filter( 'ptrn/patron_link_pledge_level', array( &$this, 'filter_patreon_flow_link_pledge_level' ), PHP_INT_MAX, 3 );
				 
		// add_filter( 'get_the_excerpt', array( &$this, 'filter_gate_excerpts' ),PHP_INT_MAX,2);
		
		add_filter( 'ptrn/force_strict_oauth', array( &$this, 'turn_strict_oauth_off' ),PHP_INT_MAX,2);
		add_filter( 'ptrn/filter_excluded_posts', array( &$this, 'modify_protected_post_types' ),PHP_INT_MAX,2);
		add_filter( 'ptrn/filter_excluded_posts_metabox', array( &$this, 'modify_protected_post_types' ),PHP_INT_MAX,2);
		
		// add_action( 'register_form', array($this, 'showPatreonButton' ) );
		add_action( 'woocommerce_register_form_end', array($this, 'showPatreonButton') );

		// add_action( 'login_form', array($this, 'showPatreonButton' ) );
		add_action( 'woocommerce_login_form_end', array($this, 'showPatreonButton' ) );
		
		add_action( 'activated_plugin', array(&$this, 'after_activate' ), 10,2 );		
		
		//add_filter( 'wp_redirect', array( &$this, 'redirect_patreon_login' ),PHP_INT_MAX,3);
		//add_action( 'wp',  array( &$this,'save_user_last_visited_page_before_login' ),0);
		
		register_activation_hook( __FILE__, array(&$this,'activate' ));
		
		register_deactivation_hook(__FILE__, array(&$this,'deactivate'));
		
		add_action( 'show_user_profile', array( &$this, 'add_user_meta' ) );
		add_action( 'edit_user_profile', array( &$this, 'add_user_meta' ) );
		add_action( 'personal_options_update', array( &$this, 'save_user_meta' ) );
		add_action( 'edit_user_profile_update', array( &$this, 'save_user_meta' ) );
		
		// Below will allow cb_p6_a1 to prevent cb_p6 from putting post button to valid patrons viewing a protected page
		
		add_filter('cb_p6_action_before_content_filters',array( &$this, 'cb_p6_action_before_content_filters'), 10,1 );
		add_filter('cb_p6_action_after_content_filters', array( &$this, 'cb_p6_action_after_content_filters'),  10,1);
		add_filter('cb_p6_action_before_do_admin_page_tabs', array( &$this, 'add_news_section_to_admin'),  10,1);
		
		// Triggers the check for after-update actions
		add_action('init', array(&$this, 'check_after_update_actions'),15);
		
		if(is_admin()) {
			add_action( 'load-post.php',  array(&$this,'add_patron_only_meta_box'  ));
			add_action( 'load-post-new.php',  array(&$this,'add_patron_only_meta_box') );	
			add_action( 'load-post.php',  array(&$this,'add_custom_banner_meta_box'  ));
			add_action( 'load-post-new.php',  array(&$this,'add_custom_banner_meta_box') );	
			/*
			add_action( 'admin_init',  array(&$this,'add_patron_only_meta_box'  ));
			add_action( 'admin_init',  array(&$this,'add_custom_banner_meta_box'  ));
			*/
			
			
		}
		else {
			add_action('init', array(&$this, 'frontend_init'),99);
		}
		
	}
	
	public function add_admin_menus_p() {
	
		add_submenu_page ( '', $this->lang['admin_menu_label'], $this->lang['admin_menu_label'], 'administrator', 'setup_wizard_'.$this->internal['id'], array(&$this,'do_setup_wizard'), $this->internal['plugin_url'].'images/admin_menu_icon.png', 86 );
	}
	
	public function admin_init_p() {

		$this->check_redirect_to_setup_wizard();
		
		/* Save post meta on the 'save_post' hook. */
		add_action( 'save_post', array(&$this,'save_post_metas') );		
			
		add_filter( 'pre_set_site_transient_update_plugins', array(&$this, 'check_for_update' ) );
		
		$this->internal['plugin_update_url'] =  wp_nonce_url(get_admin_url().'update.php?action=upgrade-plugin&plugin='.$this->internal['plugin_slug'],'upgrade-plugin_'.$this->internal['plugin_slug']);
		
		add_filter( 'plugins_api', array( &$this, 'injectInfo' ), 90, 3 );
		
		if(!get_option('patreon-creator-id', false)) {
			add_action('cb_p6_action_before_do_settings_pages',array(&$this,'auto_get_patreon_creator_id'),99,1);
		}		
		add_action( 'cb_p6_action_after_do_setting_section', array( &$this, 'append_to_setting_sections' ) );

		add_action( 'admin_print_footer_scripts', array( &$this, "add_patron_only_content_button"));
		add_action( 'admin_print_footer_scripts', array( &$this, "add_non_patron_only_content_button"));
		
		add_action( 'cb_p6_action_after_wrapper_check_addon_license', array( &$this, 'check_this_addon_license' ),10,1 );
		
		add_action( 'wp_ajax_'.$this->internal['prefix'].'save_license', array( &$this, 'save_license_from_ajax' ),10,1 );
		
		add_action( 'wp_ajax_'.$this->internal['prefix'].'install_update_plugins', array( &$this, 'install_update_plugins' ),10,1 );
		add_action( 'wp_ajax_'.$this->internal['prefix'].'get_taxonomies_for_post_type', array( &$this, 'get_taxonomies_for_post_type' ),10,1 );
		add_action( 'wp_ajax_'.$this->internal['prefix'].'get_taxonomy_items_for_taxonomy', array( &$this, 'get_taxonomy_items_for_taxonomy' ),10,1 );
		add_action( 'wp_ajax_'.$this->internal['prefix'].'fetch_remote_news', array( &$this, 'fetch_remote_news' ),10,1 );
		add_action( 'wp_ajax_'.$this->internal['prefix'].'set_patron_only_excerpt_background_color', array( &$this, 'set_patron_only_excerpt_background_color' ),10,1 );
				
	}
	public function frontend_init_p()
	{
		
		add_filter( 'cb_p6_filter_vars_after_make_to_patreon_url', array( &$this, 'append_params_to_url' ) );
				
	}
	public function init_p()
	{
		
		if( $this->required_plugins() OR !$this->opt['setup_done'] ) {
			return;
		}
		
		add_filter( 'cb_p6_filter_vars_after_init_internal_vars', array( &$this, 'modify_parent_internal_vars' ) );
		
		add_filter( 'cb_p6_filter_vars_after_load_language', array( &$this, 'modify_parent_language' ) );
		
		add_filter( 'cb_p6_filter_vars_after_load_language', array( &$this, 'modify_lang' ) );
		
		add_filter( 'cb_p6_filter_vars_before_save_settings', array( &$this, 'filter_parent_settings' ),60);
		
		add_filter( 'cb_p6_filter_vars_before_make_to_patreon_link', array( &$this, 'filter_cb_p6_link' ),60);
		
		add_action( 'cb_p6_action_before_process_template', array( &$this, 'parent_content_processing' ) );
		
	}
	public function load_options_p()
	{
		// Initialize and modify plugin related variables
		
		return $this->internal['core_return'];
		
	}
	
	// Plugin specific functions start

	public function setup_languages_p()
	{
		// Here we do plugin specific language procedures. 
		
		// Set up the custom post type and its taxonomy slug into options:
		
		$current_lang=get_option($this->internal['prefix'].'lang_'.$this->opt['lang']);
		
		// Get current options
		
		$current_options=get_option($this->internal['prefix'].'options');
		
		// Update options :
		
		update_option($this->internal['prefix'].'options',$current_options);
		
		// Set current options the same as well :
		
		$this->opt=$current_options;
		
	}
	public function activate_p() {
	
		if( ( !isset( $this->opt['setup_done']) OR !$this->opt['setup_done'] ) AND !$this->opt['setup_is_being_done'] ) {
			$this->opt['redirect_to_setup_wizard'] = true;
			$this->update_opt();
		}
	}
	public function check_redirect_to_setup_wizard_p()
	{
	
		if(is_admin() AND current_user_can('manage_options')) {
		
			// If setup was not done, redirect to wizard

			if( isset( $this->opt['redirect_to_setup_wizard'] ) AND $this->opt['redirect_to_setup_wizard'] ) {

				$this->opt['setup_is_being_done']=true;
				$this->opt['redirect_to_setup_wizard'] = false;
				$this->update_opt();
				// wp_redirect($this->internal['admin_url'].'admin.php?page=settings_cb_p6&cb_p6_tab=content_locking');
				wp_redirect($this->internal['admin_url'].'admin.php?page=setup_wizard_'.$this->internal['id'].'&setup_stage=0');
				exit;	
			}
		}
		
	}	
	public function enqueue_frontend_styles_p()
	{
		wp_enqueue_style( $this->internal['id'].'-css-main', $this->internal['template_url'].'/'.$this->opt['template'].'/style.css' );
	}
	public function enqueue_admin_styles_p()
	{
		$current_screen=get_current_screen();
		global $cb_p6;
		if(is_admin())
		{
			wp_enqueue_style( 'wp-jquery-ui-dialog' );
			
			wp_enqueue_style( $this->internal['id'].'-css-admin', $this->internal['plugin_url'].'plugin/includes/css/admin.css' );
			
			// Always queue cb_p6 styles if it exists:
			
			if ( isset($cb_p6->internal ) ) {
				wp_enqueue_style( $cb_p6->internal['id'].'-css-admin', $cb_p6->internal['plugin_url'].'plugin/includes/css/admin.css' );
			
			}
			
			wp_enqueue_style( 'wp-color-picker' );
			
		}		
	}
	public function enqueue_frontend_scripts_p()
	{
	
	}	
	public function enqueue_admin_scripts_p()
	{
		// This will enqueue the Media Uploader script
		wp_enqueue_media();	
		wp_enqueue_script( 'wp-color-picker');
		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_script( $this->internal['id'].'-js-admin', $this->internal['plugin_url'].'plugin/includes/scripts/admin.js' );
    
	}	
	public function check_license_p($license=false) 
	{
		global $wp_version, $theme_version, $theme_base, $api_url;
		
	
		if(!$license)
		{
			$license=$this->opt['license'];
		}
		
		$store_url = 'https://updates.codebard.com';
		$item_name = $this->internal['plugin_name'];
		$api_params = array(
			'action' => 'check_license',
			'license' => $license,
			'site' => base64_encode(get_site_url()),
			'item_name' => base64_encode($item_name)
			
		);
		$response = wp_remote_get( add_query_arg( $api_params, $store_url ), array( 'timeout' => 15, 'sslverify' => false,'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url') ) );

		if ( is_wp_error( $response ) )
			return false;
			
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		
		if( $license_data->license == 'valid' ) {
			return 'valid';
			// this license is still valid
		} else {
			return 'invalid';
			// this license is no longer valid
		}
	}
	public function check_this_addon_license_p($v1)
	{
		$addon_key = $v1;

		// This function checks if the addon license is valid and displays it in addons list of parent
	
		if($addon_key != 'patron_plugin_pro')
		{
			return;			
		}
		
		if(isset($this->opt['license']))
		{
			$license_status = $this->check_license($this->opt['license']);
						
		}
		else
		{
			$license_status = 'invalid';
		}
	
		if($license_status == 'valid')
		{
		
			echo '<div class="cb_addon_status">'.$this->lang['license_active'].'</div><div class="cb_license_div"><form class="cb_license_save_form" action="'.admin_url('admin-ajax.php').'" method="post">';
			echo '<input type="text" name="cb_license" class="cb_addon_license_input" value="'.$this->opt['license'].'" />';
			echo '<button type="submit" class="cb_p6_admin_button" value="submit">'.$this->lang['change_license'].'</button>
			<input type="hidden" name="action" value="'.$this->internal['prefix'].'save_license" /><input type="hidden" name="cb_plugin" value="'.$this->internal['id'].'" /></div>';
			
		}
		else
		{
			
			echo '<div class="cb_license_div"><form class="cb_license_save_form" action="'.admin_url('admin-ajax.php').'" method="post">';
			echo '<input type="text" name="cb_license" class="cb_addon_license_input" onfocus="if(this.value == \''.$this->lang['please_enter_your_license_key'].'\') {this.value=\'\'}" onblur="if(this.value == \'\'){this.value =\''.$this->lang['please_enter_your_license_key'].'\'}" value="'.$this->lang['please_enter_your_license_key'].'" />';
			echo '<button type="submit" class="cb_p6_admin_button" value="submit">'.$this->lang['save_license'].'</button>
			<input type="hidden" name="action" value="'.$this->internal['prefix'].'save_license" /><input type="hidden" name="cb_plugin" value="'.$this->internal['id'].'" /></div>';
			
		}
		
		
	}
	public function save_license_from_ajax_p($v1)
	{

		
		$current_user = wp_get_current_user();
		
		if(!($this->is_user_wp_admin($current_user->ID) AND is_admin()))
		{
			return;			
		}		
		
		$license = $_REQUEST['cb_license'];
			
		$license_check=$this->check_license($license);

		if($license_check=='valid')
		{
			
			$this->opt['license']=$license;
			
			update_option($this->internal['prefix'].'options',$this->opt);		
			$result = 'valid_saved';
			$message =  $this->lang['license_successfully_saved'];
		}					
		if($license_check=='invalid')
		{	
			$result = 'invalid';
			$message =  $this->lang['license_invalid'];
		}						
		if($license_check=='site_inactive')
		{
			$result = 'site_inactive';
			$message =  $this->lang['site_inactive'];

		}					
		if(!$license_check)
		{
			$result = 'no_connect';
			$message =  $this->lang['license_check_connect_failed'];
			
		}
		
		if($result!='valid_saved')
		{
			$return_result = 'error';		
			
		}
		else
		{
			$return_result = 'success';	
			
		}
		
		$response = array(
			'result' => $return_result,
			'message' => $message,
			'license' => $license,
		);
		
		
		exit(json_encode($response));


	
		
	}
	public function get_news_p()
	{
		global $wp_version, $theme_version, $theme_base, $api_url;

		$store_url = 'https://news.codebard.com';
		$item_name = $this->internal['plugin_name'];
		$api_params = array(
			'action' => 'get_news',
			'site' => base64_encode(get_site_url()),
			'item_name' => base64_encode($item_name)
			
		);
		$response = wp_remote_get( add_query_arg( $api_params, $store_url ), array( 'timeout' => 15, 'sslverify' => false,'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url') ) );


		$response = wp_remote_retrieve_body( $response );
		
		if( $response != '' AND !is_wp_error( $response ) ) {
			$news_response=$response;
			// this license is still valid
		} else {
			$news_response='<img src="'.get_template_directory_uri().'/images/rapier-logo.png" border="0">';
			// this license is no longer valid
		}
		
		return $news_response;

	}
	public function check_for_update_p($checked_data) 
	{
		global $wp_version, $plugin_version, $plugin_base;
	
		
		if ( empty( $checked_data->checked ) ) {
			return $checked_data;
		}

		$api_url = $this->internal['update_api_url'];
		
		$request = array(
			'slug' => $this->internal['plugin_dir_name'],
			'plugin' => $this->internal['plugin_slug'],
			'version' => $this->internal['version'] 
		);
	
		// Start checking for an update
		$send_for_check = array(
			'body' => array(
				'action' => 'plugin_information', 
				'request' => serialize($request),
				'site' => base64_encode(get_site_url()),
				'license' => $this->opt['license'],
				'item_name' => base64_encode($this->internal['plugin_name']),
			),
			'sslverify' => false,
			'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
		);

		$raw_response = wp_remote_post($api_url, $send_for_check);

		if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200))
		{
			$response = unserialize($raw_response['body']);
	
		
			if (is_object($response) && !empty($response)) 
			{
	
				if(version_compare( $this->internal['version'], $response->new_version, '<' ))
				{
					// Feed the update data into WP updater
					$checked_data->response[$this->internal['plugin_slug']] = $response;
					// place update link into update lang string :
					
					$update_link = $this->process_vars_to_template(array('plugin_update_url'=>$this->internal['plugin_update_url']),$this->lang['update_available']);
		
					$this->queue_notice($update_link,'info','update_available','perma',true);
		
				}
			}
		}
		else
		{
			
			$this->queue_notice($this->lang['error_couldnt_connect_to_update_server'],'error','error_couldnt_connect_to_update_server','admin');
			
			$this->queue_notice($raw_response->get_error_message(),'error','error_couldnt_connect_to_update_server_message','admin');
		
		}

		
		return $checked_data;
	}	
	public function check_plugin_info_p($obj, $action, $arg)
	{

		
		if (($action=='query_plugins' || $action=='plugin_information') && 
		    isset($arg->slug) && $arg->slug === $this->internal['id']) {
				

			return $this->getRemote('plugin_information');
		}
		
		return $obj;		
		
	}
	public function injectInfo_p($result, $action = null, $args = null)
	{
	
		
    	$relevant = ($action == 'plugin_information') && isset($args->slug) && (
			($args->slug == $this->internal['id']) || ($args->slug == dirname($this->internal['plugin_slug']))
		);
		if ( !$relevant ) {
			return $result;
		}
	
		return $this->getRemote('plugin_information');
		
	}
	public function upgrade_p($v1,$v2=false) {
		
		$upgrader_object = $v1;
		$options = $v2;
		$got_updated = false;
		
		if(!$options OR !is_array($options)) {
			// Not an update.
			return;
		}
	
		if ( $options['action'] == 'update' && $options['type'] == 'plugin') {
			
			if(isset( $options['plugins'] )) {
				// Multi plugin update. Iterate:
				// Iterate through the plugins being updated and check if ours is there
				foreach( $options['plugins'] as $plugin ) {
					
					if( $plugin == $this->internal['plugin_slug'] ) {
						$got_updated = true;
					}
				}	
			}
			if( isset( $options['plugin'] )) {
				// Single plugin update

				if( $options['plugin'] == $this->internal['plugin_slug'] ) {
					$got_updated = true;
				}
				
			} 
			
			if( $got_updated ) {
				
				// Yep, this plugin was updated. Do whatever necessary post-update action:
						
				$this->dismiss_admin_notice(array('notice_id'=>'update_available','notice_type'=>'info'));
				$this->dismiss_admin_notice(array('notice_id'=>'after_update_notice','notice_type'=>'info'));
				
				$this->opt['after_update_notice_shown'] = false;
				$this->opt['plugin_was_updated'] = true;
		
				$this->update_opt();
		
		
				unset($this->opt['content']['perma_notices']['info']['after_update_notice']);
				
				
				// Get the updated after update notice from file:

				include_once($this->internal['plugin_path'].'plugin/includes/after_update_notice.php');
			
				// $notice var comes from above include
				
				$this->queue_notice( $notice,'info','after_update_notice','perma',true);		
			}
		}
	}
	public function toWpFormat_p()
	{
		$info = new stdClass;
		
		//The custom update API is built so that many fields have the same name and format
		//as those returned by the native WordPress.org API. These can be assigned directly. 
		$sameFormat = array(
			'name', 'slug', 'version', 'requires', 'tested', 'rating', 'upgrade_notice',
			'num_ratings', 'downloaded', 'active_installs', 'homepage', 'last_updated',
		);
		foreach($sameFormat as $field){
			if ( isset($this->$field) ) {
				$info->$field = $this->$field;
			} else {
				$info->$field = null;
			}
		}
		//Other fields need to be renamed and/or transformed.
		$info->download_link = $this->download_url;
		$info->author = $this->getFormattedAuthor();
		$info->sections = array_merge(array('description' => ''), $this->sections);
		if ( !empty($this->banners) ) {
			//WP expects an array with two keys: "high" and "low". Both are optional.
			//Docs: https://wordpress.org/plugins/about/faq/#banners
			$info->banners = is_object($this->banners) ? get_object_vars($this->banners) : $this->banners;
			$info->banners = array_intersect_key($info->banners, array('high' => true, 'low' => true));
		}
		return $info;
	}
	public function getRemote_p($action = '')
	{
		$request = array(
			'slug' => $this->internal['plugin_dir_name'],
			'plugin' => $this->internal['id'],
			'version' => $this->internal['version'] 
		);
	
		// Start checking for an update
		$send_for_check = array(
			'body' => array(
				'action' => 'plugin_information', 
				'request' => serialize($request),
				'site' => base64_encode(get_site_url()),
				'license' => $this->opt['license'],
				'item_name' => base64_encode($this->internal['plugin_name']),
			),
			'sslverify' => true,
			'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
		);
		// Make the POST request
		$request = wp_remote_post($this->internal['update_api_url'], $send_for_check );
		
		// Check if response is valid
		if ( !is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) === 200 ) {
		
			
			return @unserialize( $request['body'] );
		}
		
		return false;
	}
	public function save_license_p($v1)
	{
		$current_user = wp_get_current_user();
		
		if(!($this->is_user_wp_admin($current_user->ID) AND is_admin()))
		{
			return;			
		}		
		
		
		$request = $v1;
		$license = $request['license'];
			
		$license_check=$this->check_license($license);


		if($license_check=='valid')
		{
			
			$this->opt['license']=$license;
			
			update_option($this->internal['prefix'].'options',$this->opt);		

			$this->queue_notice($this->lang['license_valid'],'success','license_valid','admin');
		}					
		if($license_check=='invalid')
		{	

			$this->queue_notice($this->lang['license_invalid'],'error','license_invalid','admin');
		}						
		if($license_check=='site_inactive')
		{
			$this->queue_notice($this->lang['site_inactive'],'error','site_inactive','admin');

		}					
		if(!$license_check)
		{
			
			$this->queue_notice($this->lang['license_check_connect_failed'],'error','license_check_connect_failed','admin');
			
		}		
		
	}
	public function check_requirements_and_setup_p()
	{

		// Below function checks the request in any way necessary, and queues any action/filter depending on request. This way, we avoid filtering content or putting any actions in pages or operations not relevant to plugin
				

		if(isset($this->opt['last_operation_result_key']) AND $this->opt['last_operation_result_key']=='error_auto_parsing_credentials_failed')
		{
		
			// Api credentials fail at setup. Show error screen:
			//add_action('cb_p6_action_before_do_settings_pages',array(&$this,'api_credentials_fail_during_setup'),99,1);
		}

		if(isset($this->opt['setup_successful_show_guides']) AND $this->opt['setup_successful_show_guides']==true)
		{
		
			// Api credentials fail at setup. Show error screen:
			//add_action('cb_p6_action_before_do_settings_pages',array(&$this,'show_final_guide_after_setup'),99,1);
		}				
		
		
	}
	public function do_setup_wizard_p()
	{
		// Here we do and process setup wizard if it is not done:
		
		
		// Set the setup stage if setup is not done, setup is reset or stage 0 is requested
		if(!isset($_REQUEST[$this->internal['prefix'].'setup_stage']) OR $_REQUEST[$this->internal['prefix'].'setup_stage'] == '0' OR isset( $_REQUEST[$this->internal['prefix'].'reset_setup_wizard'] ) ) {
			$_REQUEST[$this->internal['prefix'].'setup_stage'] = 0;
			$this->opt['setup_wizard_stage'] = 0;

		}
		
		if ( !$this->opt['setup_done'] ) {
			
			// Get cb_p6 options if they exist:
			
			$cb_p6_opt = get_option('cb_p6_options');
			$cb_p6_opt['quickstart']['site_account']='Update this';
			$cb_p6_opt['setup_is_being_done']=true;
			$cb_p6_opt['pro_pitch_done']=true;
			$cb_p6_opt['queue_modal']=false;
			$cb_p6_opt['setup_stage']=2;

			update_option('cb_p6_options',$cb_p6_opt);
			
			// Suppress PW notices:
			
			update_option('patreon-mailing-list-notice-shown',1);
			update_option( 'patreon-rate-plugin-notice-shown', 1 );
			update_option( 'patreon-file-locking-feature-notice-shown', 1 );
			update_option( 'patreon-gdpr-notice-shown', 1 );
			
			$this->internal['setup_is_being_done'] = true;
			$this->opt['setup_is_being_done']=true;
		}
		
		$this->opt['setup_wizard_stage'] = (int) $_REQUEST[$this->internal['prefix'].'setup_stage'];
		$this->update_opt();
		
		require($this->internal['plugin_path'].'plugin/includes/setup_'.$this->opt['setup_wizard_stage'].'.php');
		
		if( $this->opt['setup_wizard_stage'] == '2' ) {
			
			// Final setup stage - remove setup related options
			
			// Get cb_p6 options if they exist:
			
			$cb_p6_opt = get_option('cb_p6_options');
			$cb_p6_opt['setup_is_being_done']=false;
			$cb_p6_opt['pro_pitch_done']=true;
			$cb_p6_opt['queue_modal']=false;
			$cb_p6_opt['setup_stage']=2;
			$cb_p6_opt['setup_done']=true;

			update_option('cb_p6_options',$cb_p6_opt);			
			
			
			$this->internal['setup_is_being_done'] = false;
			$this->opt['setup_is_being_done'] = false;
			$this->opt['setup_done'] = true;
			$this->update_opt();
			
			
		}

	}
	public function process_credentials_at_setup_p($v1)
	{
		global $cb_p6;
		$request=$v1;

		
		$credentials = $request['opt'][$this->internal['prefix'].'client_details_input'];
		
		if($credentials=='')
		{
			$error=true;
		
		}
		if($credentials!='')
		{
			
			// Wow wow wow. We got the client credentials copy pasted directly - parse them:
			$process=stripslashes($credentials);
			
		
			$snip_start = strpos($process,'ID:')+3;
			$snip = stripslashes(substr($credentials,$snip_start,strlen($process)));

			$snip=str_replace('API Version:','',$snip);
			$snip=str_replace('Client Secret:','',$snip);
			$snip=str_replace('Creator\'s Access Token:','',stripslashes($snip));
			$snip=str_replace('Creator\'s Refresh Token:','',stripslashes($snip));

			$snip = explode(PHP_EOL, $snip);
			
			$credentials=array();
			foreach($snip as $key => $value)
			{
				$snip[$key]=trim($snip[$key]);
				
				if($snip[$key]!='')
				{
					$credentials[]=$snip[$key];
					
				}
				
			}
			
			// Remove api version:
			
			array_splice($credentials, 1, 1);
			
			// Cleaned, prepared. Check if we have all 4 keys:

			if(!isset($credentials) OR !is_array($credentials))
			{
				$this->opt['last_operation_result']=$this->lang['error_auto_parsing_credentials_failed'];
				$this->update_opt();
			}
			else
			{
			
				$error=false;
				foreach($credentials as $key => $value)
				{
					if($credentials[$key]=='')
					{
						$error=true;
					}
					
				}

				if($error==true)
				{
					$this->opt['last_operation_result']=$this->lang['error_auto_parsing_credentials_failed'];
					$this->update_opt();
					
				}
				else
				{

					// Update options from array:
					
					update_option('patreon-client-id',$credentials[0]);
								
					update_option('patreon-client-secret',$credentials[1]);
					
					update_option('patreon-creators-access-token',$credentials[2]);
					
					update_option('patreon-creators-refresh-token',$credentials[3]);
					
				}
			}
		
		}
		
		if($error)
		{
			$this->opt['last_operation_result']=$this->lang['error_auto_parsing_credentials_failed'];
			$this->opt['last_operation_result_key']='error_auto_parsing_credentials_failed';
			$this->update_opt();
			
			wp_redirect($this->internal['admin_url'].'admin.php?page=setup_wizard_'.$this->internal['id'].'&'.$this->internal['prefix'].'setup_stage=1');
			exit;			
			
		}
		else
		{
				// Success 
				
				unset($this->opt['last_operation_result']);
				unset($this->opt['last_operation_result_key']);
				$this->opt['setup_is_being_done']=true;
				$this->opt['setup_successful_show_guides']=true;
				$this->update_opt();
							
		
				wp_redirect($this->internal['admin_url'].'admin.php?page=setup_wizard_'.$this->internal['id'].'&'.$this->internal['prefix'].'setup_stage=2');
				exit;				
			
			
		}
		
		 
	}
	public function api_credentials_fail_during_setup_p($v1)
	{
		global $cb_p6;

		// This happened during setup, and credentials failed. Drop a notifier.
		$this->internal['setup_is_being_done']=true;
		$cb_p6->internal['setup_is_being_done']=true;

		$this->opt['setup_is_being_done']=false;
		$this->opt['setup_done']=true;
		unset($this->opt['last_operation_result']);
		unset($this->opt['last_operation_result_key']);

		$this->update_opt();

		require($this->internal['plugin_path'].'plugin/includes/api_credentials_setup_failed.php');
		
	}
	public function show_final_guide_after_setup_p($v1)
	{
		global $cb_p6;

		
		// This happened during setup, and credentials failed. Drop a notifier.
		$this->internal['setup_is_being_done']=true;
		$cb_p6->internal['setup_is_being_done']=true;

		$this->opt['setup_is_being_done']=false;
		$this->opt['setup_done']=true;
		$this->opt['setup_successful_show_guides']=false;
		unset($this->opt['last_operation_result']);
		unset($this->opt['last_operation_result_key']);

		$this->update_opt();

		require($this->internal['plugin_path'].'plugin/includes/setup_done.php');
		
	}
	public function check_cb_p6_exists_p($v1)
	{
		 
		$active_plugins=get_option('active_plugins');
		
		if(in_array('patron-button-and-widgets-by-codebard/index.php',$active_plugins))
		{	

			$this->internal['cb_p6_installed']=true;
		}		
		
		
	}
	public function required_plugins_p($v1)
	{
		if(!function_exists('wp_get_current_user')) {
			include(ABSPATH . "wp-includes/pluggable.php"); 
		}
		
		if ( !( is_admin() AND current_user_can('manage_options') ) ) {
			return;
		}
		
		$active_plugins=get_option('active_plugins');
		
		if(!function_exists('is_plugin_active')) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		
		$plugins = get_plugins();
		$to_process = false;
		
		// Iterate through required plugins and match against existing ones
		foreach ( $this->internal['required_plugins'] as $key => $value ) {
			
			$installed = false;
			$active = false;
			$correct_version = false;
			$process = false;
			
			foreach ( $plugins as $plugin_key => $plugin_value ) {

				if ( $plugin_key == $this->internal['required_plugins'][$key]['slug'] ) {
				
					$installed = true;
					
					if ( is_plugin_active( $plugin_key ) ) {
						
						$active = true;
					}
					
					if(version_compare( $plugins[$plugin_key]['Version'], $this->internal['required_plugins'][$key]['version'], '>=' ))
					{
						
						$correct_version = true;
					}
					
				}
				
			}
			
			if ( !$installed OR !$active OR !$correct_version ) {
				$process = true;		
			}
			
			if ( $process ) {
				
				if ( !$to_process ) {
					$to_process = array();
				}
				
				$to_process[$key] = $this->internal['required_plugins'][$key];
				
				$to_process[$key]['installed'] = $installed;
				$to_process[$key]['active'] = $active;
				$to_process[$key]['correct_version'] = $correct_version;
				
			}
			
		}
		
		return $to_process;
		
	}
	public function check_remove_old_pw_p($v1) {
		
		if ( !( is_admin() AND current_user_can('manage_options') ) ) {
			return;
		}		
		
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
		$plugins = get_plugins();
		
		// Iterate through required plugins and match against existing ones
		foreach ( $plugins as $key => $value ) {

			if ( $key = 'patreon-wordpress/patreon.php' ) {
				
				// found it.
				// deactivate first
				
				@deactivate_plugins( 'patreon-wordpress/patreon.php' );
				
				// Uninstall
				
				@delete_plugins( array( 'patreon-wordpress/patreon.php' ) );
				
				
				return true;
			}
		
		}
		return false;
	}
	public function install_update_plugins_p($v1) {
		
		if(!function_exists('wp_get_current_user')) {
			include(ABSPATH . "wp-includes/pluggable.php"); 
		}
		
		if ( !( is_admin() AND current_user_can('manage_options') ) ) {
			return;
		}
				
		$required_plugins = $this->required_plugins();
		
		include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' ); //for plugins_api..
		
//includes necessary for Plugin_Upgrader and Plugin_Installer_Skin
		include_once( ABSPATH . 'wp-admin/includes/file.php' );
		include_once( ABSPATH . 'wp-admin/includes/misc.php' );
		include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
		include_once( $this->internal['plugin_path'] . 'plugin/includes/upgrader_skin.php' );
		
		$errors_encountered = false;
		
		foreach ( $required_plugins as $key => $value ) {
			
			
			// New concise format deactivates, deletes and reinstalls all plugins. If necessary, old format that does different actions depending on not installed, inactive, and wrong version states can be retrieved from commit f5dea12032b249118f5912ab83ade82cfe96ac5a at github			
			
				
			if( !$required_plugins[$key]['installed'] OR !$required_plugins[$key]['correct_version'] OR !$required_plugins[$key]['activated'] ) {
				
				// Deactivate
				
				if ( $required_plugins[$key]['activated'] ) {
				
					echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_info">deactivating</div>';
					echo '<br>';
					
					@deactivate_plugins( $required_plugins[$key]['slug'] );
					
					if ( is_plugin_active( $required_plugins[$key]['slug'] ) ) {
						// Deactivation failed
						
						echo '<div class="cb_p6_a1_plugin_install_error">Deactivation of old plugin failed!</div>';
					}
				
				}
				
				// Uninstall
				
				if ( $required_plugins[$key]['installed'] ) {
					
					echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_info">uninstalling</div>';
					echo '<br>';				
					
					$error_check = @delete_plugins( array( $required_plugins[$key]['slug'] ) );
					
					if ( is_wp_error( $error_check ) ) {
						
						echo '<div class="cb_p6_a1_plugin_install_error">Uninstallation of old plugin failed! Error was: '.$error_check->get_error_message().'</div>';
					}
				}
				
				// Install
				
				$api = plugins_api( 'plugin_information', array(
					'slug' => $required_plugins[$key]['plugin_name_slug'],
					'fields' => array(
						'short_description' => false,
						'sections' => false,
						'requires' => false,
						'rating' => false,
						'ratings' => false,
						'downloaded' => false,
						'last_updated' => false,
						'added' => false,
						'tags' => false,
						'compatibility' => false,
						'homepage' => false,
						'donate_link' => false,
					),
				));
				
				$api->download_link = $required_plugins[$key]['download_url'];
						
				echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_info">downloading & installing</div>';
				echo '<br>';
				// Ob needed to prevent further output by upgraders
				ob_start();
				
				// Updater details credit 
				// https://stackoverflow.com/a/38768707/1792090
				
				// Non silent version below
				// $cb_p6_a1_upgrader = new Plugin_Upgrader( new Plugin_Installer_Skin( compact('title', 'url', 'nonce', 'plugin', 'api') ) );
				
				$cb_p6_a1_upgrader = new \Plugin_Upgrader( new Quiet_Skin() );
				// Keep installation silent
				
				$install_result = $cb_p6_a1_upgrader->install($api->download_link);
				$dummy = ob_get_clean();
								
				if ( is_wp_error( $install_result ) ) {
					
					echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_fail">installation failed</div>';
					echo 'Error was "'.$install_result->get_error_message().'"';
					echo '<br>';
					
					$errors_encountered = true;
					
				}
				else {
					if ( $install_result ) {
						echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_success">installation successful!</div>';
						echo '<br>';
								
						$activate_plugin = activate_plugin( WP_PLUGIN_DIR  . '/' . $required_plugins[$key]['slug'] );
					
						if ( is_wp_error( $activate_plugin ) ) {
							
							echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_fail">activation failed</div>';
							echo '<br>';
							echo 'Error was "'.$activate_plugin->get_error_message().'"';
							echo '<br>';
							$errors_encountered = true;
						}
						else {
							// if ( is_plugin_active( WP_PLUGIN_DIR  . '/' . $required_plugins[$key]['slug'] ) ) {
							if ( is_null( $activate_plugin ) ) {
								echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_success">activation successful!</div>';
								echo '<br>';
							}
							else {
								echo $required_plugins[$key]['name']. ' - <div class="cb_p6_a1_plugin_install_fail">activation failed</div>';
								echo '<br>';
								$errors_encountered = true;
							}
						}						
						
					}

				}				
				
			}
				
		}
		
		if ( $this->required_plugins() ) {
			
			// There are still issues
			
			?>
			<h2>Sorry - couldn't complete setup</h2>
			<div class="cb_p6_a1_setup_wizard_text_small">You can retry configuring plugins again. If this issue persists, please contact CodeBard help desk <a href="https://codebard.com/help-desk" target="_blank">here</a></div>
				<form id="cb_p6_a1_ajax_plugin_install_form" method="post" action="<?php echo $this->internal['admin_url'].'admin.php?page=setup_wizard_'.$this->internal['id']; ?>" ajax_target_div="cb_p6_a1_install_update_plugin_results">
					<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="Retry configuring plugins"></p>
					<input type="hidden" name="wp_ajax_<?php echo $this->internal['prefix'].'install_update_plugins'; ?>" value="1" />
					<input type="hidden" name="<?php echo $this->internal['prefix'].'setup_stage'; ?>" value="0" />
				</form>
			
			<?php
			
		}
		else {
			
			?>
			<h2>Great! All good! Now we can connect your site to Patreon</h2>
				<form method="post" action="<?php echo $this->internal['admin_url'].'admin.php?page=setup_wizard_'.$this->internal['id']; ?>" ajax_target_div="cb_p6_a1_install_update_plugin_results">
					<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="Let's go!"></p>
					<input type="hidden" name="<?php echo $this->internal['prefix'].'setup_stage'; ?>" value="1" />
				</form>
			
			<?php	
			
			
		}
		
		// Exit for ajax response (html)
		
		exit();
		
	}
	
	
	public function append_to_setting_sections_p($v1)
	{
		$tab=$v1;

		if($tab=='patreon_api')
		{
			if(file_exists($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php'))
			{
				require_once($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php');
				
			}
			
		}
		if($tab=='content_locking')
		{
			if(file_exists($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php'))
			{
				require_once($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php');
				
			}
			
		}
		if($tab=='customize_interface')
		{
			if(file_exists($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php'))
			{
				require_once($this->internal['plugin_path'].'plugin/includes/setting_sections/'.$tab.'.php');
				
			}
			
		}
		
	}
	public function modify_parent_language_p($v1)
	{
		$lang = $v1;
		
	
		$lang['plugin_name']=$this->lang['plugin_name'];
		$lang['admin_menu_label']=$this->lang['admin_menu_label'];

		
		return $lang ;
	}
	public function modify_parent_internal_vars_p($v1)
	{
		$internal_vars = $v1;
		
		// Check if woocommerce tab exists, if not, add it:
		
		if(!array_key_exists('woocommerce',$internal_vars['admin_tabs']))
		{
			
			
		}

		foreach($internal_vars['admin_tabs'] as $key => $value)
		{
			
			$reordered_tabs['admin_tabs'][$key]=$internal_vars['admin_tabs'][$key];
			
			// Insert our tab after staff tab:
			
			if($key=='sidebar_widgets')
			{
				$reordered_tabs['admin_tabs']['patreon_api'] = array();
				$reordered_tabs['admin_tabs']['content_locking'] = array();
				$reordered_tabs['admin_tabs']['customize_interface'] = array();
				
			}
			
		}
		$internal_vars['admin_tabs']=$reordered_tabs['admin_tabs'];

		
		return $internal_vars;
	}
	public function filter_parent_settings_p($v1)
	{

		$request = $v1;
		$options=$request['opt'];

		// This function filters the settings sent to parent for saving and takes out the ones belonging to itself.
		$skip_single_fields=false;
		foreach($options as $key => $value) {
	
			if(substr($key,0,8)==$this->internal['id'])
			{
				// This setting belongs to this addon. Add it to our options and unset it from parent:

				// Remove the prefix from key :
				
				$local_key = str_replace($this->internal['prefix'],'',$key);
				
				$local_opts[$local_key]=$options[$key];
				
				
				if($key==$this->internal['prefix'].'client_details_input' AND $options[$key]!='')
				{
					// Wow wow wow. We got the client credentials copy pasted directly - parse them:
					$process=stripslashes($options[$key]);
					$snip_start = strpos($process,'ID:')+3;
					$snip = substr($options[$key],$snip_start,strlen($process));
					
					$snip=str_replace('API Version:','',$snip);
					$snip=str_replace('Client Secret:','',$snip);
					$snip=str_replace('Creator\'s Access Token:','',stripslashes($snip));
					$snip=str_replace('Creator\'s Refresh Token:','',stripslashes($snip));
			
					$snip = explode(PHP_EOL, $snip);
					
			
					foreach($snip as $key => $value)
					{
						$snip[$key]=trim($snip[$key]);
						
						if($snip[$key]!='')
						{
							$credentials[]=$snip[$key];
							
						}
						
						
					}
					// Unset api version
					
					array_splice($credentials, 1, 1);
					
					// Cleaned, prepared. Check if we have all 4 keys:
					
					if(!isset($credentials) OR !is_array($credentials))
					{
						$this->opt['last_operation_result']=$this->lang['error_auto_parsing_credentials_failed'];
						$this->update_opt();
						continue;
					}
					
					$error=false;
					foreach($credentials as $key => $value)
					{
						if($credentials[$key]=='')
						{
							$error=true;
						}
						
					}
	
					if($error==true)
					{
						$this->opt['last_operation_result']=$this->lang['error_auto_parsing_credentials_failed'];
						$this->update_opt();
				
						continue;	
					}
					else
					{
				
						// Update options from array:
						
					
						update_option('patreon-client-id', $credentials[0]);
					
						update_option('patreon-client-secret', $credentials[1]);
						
						update_option('patreon-creators-access-token', $credentials[2]);
						
						update_option('patreon-creators-refresh-token', $credentials[3]);
						
					}
				
					// Dont do singular fields now:
					$skip_single_fields=true;
					
				}
				elseif($key==$this->internal['prefix'].'creator_id_input' AND $options[$key]!='')
				{
					// Wow wow wow. We got the client credentials copy pasted directly - parse them:
				
					preg_match("/u=([0-9]+)\"\sdata/", stripslashes($options[$key]), $output_array);

					
					$creator_id = $output_array[1];
				
					$error=false;
					
					if($creator_id=='')
					{
						$error=true;
						
					}
					
				
					if($error==true)
					{
						$this->opt['last_operation_result']=$this->lang['error_auto_parsing_login_failed'];
						$this->update_opt();
				
						continue;	
					}
					else
					{
				
						// Update options from array:
						
					
						update_option('patreon-creator-id',$creator_id);
						
														
						
					}
				
					// Dont do singular fields now:
					$skip_single_fields=true;
					
				}
				else
				{
		
					if($key==$this->internal['prefix'].'patreon_client_id' AND $options[$key]!='' AND !$skip_single_fields)
					{
						update_option('patreon-client-id',$options[$key]);
						
					}

					if($key==$this->internal['prefix'].'patreon_client_secret' AND $options[$key]!='' AND !$skip_single_fields)
					{
						
						update_option('patreon-client-secret',$options[$key]);
						
					}
					if($key==$this->internal['prefix'].'patreon_creator_id' AND $options[$key]!='' AND !$skip_single_fields)
					{
						
						update_option('patreon-creator-id',$options[$key]);
						
					}
					if($key==$this->internal['prefix'].'patreon_creator_access_token' AND $options[$key]!='' AND !$skip_single_fields)
					{
						
						update_option('patreon-creators-access-token',$options[$key]);
						
					}
					if($key==$this->internal['prefix'].'patreon_creator_refresh_token' AND $options[$key]!='' AND !$skip_single_fields)
					{
						
						update_option('patreon-creators-refresh-token',$options[$key]);
						
					}
					
				
				}
				
				unset($request['opt'][$key]);

				
			}
			
		}

		if(is_array($options[$key])) {
			
			foreach($options[$key] as $option_key => $option_value) {

				if($option_key=='add_user_role_to_login_lock_exemptions' AND $options[$key]['add_user_role_to_login_lock_exemptions']!='' AND $options[$key]['add_user_role_to_login_lock_exemptions']!='nochange')
				{
					global $wp_roles;
					$local_opts['content_locking']['always_login_allowed_roles'][$options[$key]['add_user_role_to_login_lock_exemptions']] = $wp_roles->roles[$options[$key]['add_user_role_to_login_lock_exemptions']]['name'];
					
				}
				if($option_key=='remove_user_role_from_login_lock_exemptions' AND $options[$key]['remove_user_role_from_login_lock_exemptions']!='nochange')
				{
					// Add post type to gate array:
					
					unset($local_opts['content_locking']['always_login_allowed_roles'][$options[$key]['remove_user_role_from_login_lock_exemptions']]);
					unset($this->opt['content_locking']['always_login_allowed_roles'][$options[$key]['remove_user_role_from_login_lock_exemptions']]);
					$this->update_opt();
					
				}
				
				
				if($option_key=='add_post_type_to_gate' AND $options[$key]['add_post_type_to_gate']!='' AND $options[$key]['add_post_type_to_gate']!='nochange')
				{
					$post_type = $options[$key]['add_post_type_to_gate'];
					
					// Now process type and values:
					
					// Set defaults if not set:
					
					$locking_variable = '';
					
					if($options[$key]['post_locking_format']=='last_x') {
						$locking_variable = $options[$key]['lock_last_x_posts'];
					}
					if($options[$key]['post_locking_format']=='show_last_x') {
						$locking_variable = $options[$key]['show_last_x_posts'];
					}
					if($options[$key]['post_locking_format']=='age') {
						$locking_variable = $options[$key]['lock_after_x_days'];
					}
					if($options[$key]['post_locking_format']=='show_age') {
						$locking_variable = $options[$key]['show_after_x_days'];
					}
					
					// Set dates to any if the format is not date - prevents form reposts mixing stuff up, even if date values would be ignored
					if($options[$key]['post_locking_format']!='date') {
						$options[$key]['start_day'] = 'any';
						$options[$key]['start_month'] = 'any';
						$options[$key]['start_year'] = 'any';
						$options[$key]['end_day'] = 'any';
						$options[$key]['end_month'] = 'any';
						$options[$key]['end_year'] = 'any';
					}
					
				
					$local_opts['content_locking']['gated_post_types'][$post_type][$options[$key]['post_locking_format_taxonomy']][$options[$key]['post_locking_format_taxonomy_item']] =
					array(
						
						'locking_value' => $options[$key]['post_locking_value'],
						'locking_type' => $options[$key]['post_locking_format'],
						'locking_variable' => $locking_variable,
						'start_date' => array(
							'day' => $options[$key]['start_day'],
							'month' => $options[$key]['start_month'],
							'year' => $options[$key]['start_year'],
						),
						'end_date' => array(
							'day' => $options[$key]['end_day'],
							'month' => $options[$key]['end_month'],
							'year' => $options[$key]['end_year'],
						),
						
					);
						
				}
				if($option_key=='remove_post_type_from_gate' AND $options[$key]['remove_post_type_from_gate']!='nochange')
				{
					// Add post type to gate array:

					// Break the post taxonomy term string into parts
					
					$term_string = explode( '-CTERMSEP-', $options[$key]['remove_post_type_from_gate'] );
									
					unset($local_opts['content_locking']['gated_post_types'][$term_string[0]][$term_string[1]][$term_string[2]]);
					unset($this->opt['content_locking']['gated_post_types'][$term_string[0]][$term_string[1]][$term_string[2]]);
					
					// Check if any other locking option is left for this post type, taxonomy - unset items if not
					
					if ( count( $this->opt['content_locking']['gated_post_types'][$term_string[0]][$term_string[1]] ) == 0 ) {
						
						// Unset this subbranch
								
						unset($local_opts['content_locking']['gated_post_types'][$term_string[0]][$term_string[1]]);
						unset($this->opt['content_locking']['gated_post_types'][$term_string[0]][$term_string[1]]);
						
					} 
					
					// Now check if any other locking option is left for this post type - unset item if not
					
					if ( count( $this->opt['content_locking']['gated_post_types'][$term_string[0]] ) == 0 ) {
						
						// Unset this subbranch
								
						unset($local_opts['content_locking']['gated_post_types'][$term_string[0]]);
						unset($this->opt['content_locking']['gated_post_types'][$term_string[0]]);
						
					} 
	
					$this->update_opt();
					
				}
				
			}
		
		}	
		// Remove any empty options from options:
		/*
		foreach($local_opts as $local_key => $local_value)
		{
			foreach($local_opts[$local_key] as $local_key2 => $local_value2)
			{
				if($local_opts[$local_key][$local_key2]=='')
				{
					unset($local_opts[$local_key][$local_key2]);
				}
			}
			
		}
		*/
		// Unset existing branch:
		
		//unset($this->opt[$local_key]);
		//$this->update_opt();
		
		if(isset($local_opts) AND is_array($local_opts) AND count($local_opts)>0)
		{
			$this->update_settings($local_opts);		
		}
		
		// If no setting left in original request, just make it an empty array:

		
		// Now send the filtered request back: 
		
		return $request;
		
	}
	public function modify_lang_p($v1)
	{
		$parent_lang = $v1;
		
		// Loads language from db.
		
		if(isset($this->opt['lang']))
		{
			$lang = $this->opt['lang'];
		}
		else
		{
			$lang = 'en-US';			
		}		
				
	
		$lang_file = $this->internal['plugin_path'].'plugin/includes/languages/'.$lang.'.php';

		if(file_exists($lang_file))
		{
			include($lang_file);

			
			$parent_lang = array_replace_recursive(
				$lang,
				$parent_lang
			);
		
		}
		
		return $parent_lang;
		
	}
	public function add_patron_only_content_button_p()
	{
		 if(wp_script_is("quicktags"))
		{
			?>
				<script type="text/javascript">
					
					//this function is used to retrieve the selected text from the text editor
					function ppp_get_selection()
					{
						var txtarea = document.getElementById("content");
						var start = txtarea.selectionStart;
						var finish = txtarea.selectionEnd;
						return txtarea.value.substring(start, finish);
					}

					QTags.addButton( 
						"ppp_patron_only", 
						"Patron Only", 
						ppp_patron_only_callback
					);

					function ppp_patron_only_callback()
					{
						var selected_text = ppp_get_selection();
												
						jQuery('#ppp_patron_only_dialog' ).css('opacity', 1.0);
						
						if ( selected_text == '' ) {
							jQuery('#ppp_patron_only_dialog' ).html('Please select some content to make patron only. You can do this by selecting part of your content and then clicking Patron only button');
							jQuery('#ppp_patron_only_dialog' ).dialog({autoResize:true});
							return;
						}			
				
						jQuery('#ppp_patron_only_dialog').html('');
						//const regex = /(\[ppp_patron_only(.*?)\])/gm;
						
						//var regex = new RegExp("[ppp_patron_only" + testVar + "]");

				
						// var patreon_level = selected_text.match(regex).pop();
						var shortcode = /(\[ppp_patron_only(.*?)\])/.exec(selected_text);
						
						// The match for args should be in 3rd index
						
						patreon_level = "1";
						level = null;
						
						if( shortcode != null ){
								
							var args = shortcode[2].trim();
							
							
							if( args != null ) {
								// var patreon_level = selected_text.match(regex).pop();
								var level_fetch = /(\level="(.*?)\")/.exec(args);
								
								// The match for args should be in 3rd index
								
								var level = level_fetch[2].trim();
								
							}
							
							
						}
						
						// Update Patreon level with acquired level
						if ( level != null) {
							patreon_level = level;
						}
												
						if( shortcode != null ) {
							// Remove all instances of shorcode
							
							selected_text = selected_text.replace(/(\[ppp_patron_only(.*?)\])/gi,'');
							selected_text = selected_text.replace(/(\[\/ppp_patron_only])/gi,'');
							
						}

						// QTags.insertContent('[ppp_patron_only level="5"]' +  selected_text + "[/ppp_patron_only]");
						
						jQuery('#ppp_patron_only_dialog' ).prepend('Set the level for this excerpt<div id="ppp_patron_only_excerpt_level_input">$<input size="2" id="ppp_patron_only_excerpt_level_value" type="text" value="'+patreon_level+'" /></div><input type="submit" name="ppp_level_submit" id="ppp_patron_only_excerpt_level_submit" class="button button-primary" value="Save"><div id="ppp_patron_only_excerpt_to_be">'+selected_text+'</div><div id="ppp_patron_only_excerpt_level_input_source" source="text" style="display:none;"></div><br /><br />');
						
						
						jQuery('#ppp_patron_only_dialog' ).dialog({autoResize:true});				  
			
					}
				</script>
			<?php
		}
	}
	public function add_non_patron_only_content_button_p()
	{
		 if(wp_script_is("quicktags"))
		{
			?>
				<script type="text/javascript">
					
					//this function is used to retrieve the selected text from the text editor
					function ppp_np_get_selection()
					{
						var txtarea = document.getElementById("content");
						var start = txtarea.selectionStart;
						var finish = txtarea.selectionEnd;
						return txtarea.value.substring(start, finish);
					}

					QTags.addButton( 
						"ppp_non_patron_only", 
						"Non-patrons Only", 
						ppp_non_patron_only_callback
					);

					function ppp_non_patron_only_callback()
					{
						var selected_text = ppp_np_get_selection();
						
						QTags.insertContent('[ppp_non_patron_only]' +  selected_text + "[/ppp_non_patron_only]");
						
					}
				</script>
			<?php
		}
	}

	public function add_visual_tinymce_button_p() 
	{
		global $typenow;
		// Only on Post Type: post and page
		if( ! in_array( $typenow, array( 'post', 'page' ) ) )
			return ;
		add_filter( 'mce_external_plugins', array(&$this,'register_patron_only_tinymce_button') );
		// Add to line 1 form WP TinyMCE
		add_filter( 'mce_buttons', array(&$this,'add_patron_only_tinymce_button') );
	}
	public function register_patron_only_tinymce_button_p( $plugin_array ) 
	{
		$plugin_array['tinymce_patron_only_button_plugin'] = plugins_url( '/includes/scripts/tinymce_patron_only_button.js', __FILE__ );
		$plugin_array['tinymce_non_patron_only_button_plugin'] = plugins_url( '/includes/scripts/tinymce_non_patron_only_button.js', __FILE__ );
	
		return $plugin_array;
	}
	public function add_patron_only_tinymce_button_p( $buttons ) 
	{
		array_push( $buttons, 'tinymce_patron_only_button' );
		array_push( $buttons, 'tinymce_non_patron_only_button' );
		return $buttons;
	}
	public function filter_label_over_patreon_button_p($label, $reason, $user_logged_into_patreon, $is_patron, $patreon_level, $args) 
	{
		// Here we filter the label over universal button to modify according to our stuff
		
		// If post was not locked by patreon $ meta box but through Pro, lock or not filter at pro will send different lock strings to , then patreon will not properly process text by acknowledging . To override it we re-implement active patron and total pledge conditions here:

		if ( $args['patreon_level'] > 0  ) {
			
			$label = PATREON_TEXT_OVER_BUTTON_1;
			
			if ( isset( $args['patreon_active_patrons_only'] ) AND $args['patreon_active_patrons_only'] == 1 ) {
				$label = PATREON_TEXT_OVER_BUTTON_8;
			}
			
			if( isset( $args['post_total_patronage_level'] ) AND $args['post_total_patronage_level'] > 0 ) {
				$label   = PATREON_TEXT_OVER_BUTTON_9;
				
				// Double condition - override the text
				if ( isset( $args['patreon_active_patrons_only'] ) AND $args['patreon_active_patrons_only'] == 1 ) {
					$label = PATREON_TEXT_OVER_BUTTON_10;
				}
				
			}
			
		}
		 
		// Get creator full name:
		$creator_full_name = get_option( 'patreon-creator-full-name', false );
		
		if ( !$creator_full_name OR $creator_full_name == '' ) {
			$creator_full_name = 'this creator';
		}
		
		$post_id = false;
		
		if ( isset( $args['post_id'] ) ) {
			$post = get_post( $args['post_id'] );
		}
		else {
			global $post;
		}
		
		$user_logged_into_patreon = Patreon_Frontend::isUserLoggedInPatreon();
		$is_patron                = Patreon_Wordpress::isPatron( wp_get_current_user() );
		$messages                 = Patreon_Frontend::processPatreonMessages();
		$user                     = wp_get_current_user();
		$declined                 = Patreon_Wordpress::checkDeclinedPatronage( wp_get_current_user() );		
		$user_patronage           = Patreon_Wordpress::getUserPatronage();			
		
		// We init vars so picky users will not see undefined var/index errors:
		
		$post_total_patronage_level = '';
		if( isset( $args['post_total_patronage_level'] ) ) {
			$post_total_patronage_level = $args['post_total_patronage_level'];
		}
		
		$label = str_replace( '%%creator%%', $creator_full_name, $label );

		$label = apply_filters( 'patron_pro/raw_label_over_universal_button', $label, $reason, $patreon_level, $user_patronage, $is_patron, $declined, $creator_full_name, $post_total_patronage_level  );
		
		$label = str_replace( '%%creator%%', $creator_full_name, $label );
		$label = str_replace( '%%pledgelevel%%', $patreon_level, $label );
		$label = str_replace( '%%flow_link%%', Patreon_Frontend::patreonMakeCacheableFlowLink( $post ), $label );
		$label = str_replace( '%%total_pledge%%', $post_total_patronage_level, $label );
		
		return $label;
		
	}
	public function filter_label_under_patreon_button_p($label, $reason, $user_logged_into_patreon, $is_patron, $patreon_level, $state, $args) 
	{
		// Here we filter the label over universal button to modify according to our stuff
		
		// If post was not locked by patreon $ meta box but through Pro, lock or not filter at pro will send different lock strings to , then patreon will not properly process text by acknowledging . To override it we re-implement active patron and total pledge conditions here:

		$label                    = '';
		$user_logged_into_patreon = Patreon_Frontend::isUserLoggedInPatreon();
		$is_patron                = Patreon_Wordpress::isPatron( wp_get_current_user() );
		$messages                 = Patreon_Frontend::processPatreonMessages();
		$user                     = wp_get_current_user();
		$declined                 = Patreon_Wordpress::checkDeclinedPatronage( $user );		
		$user_patronage           = Patreon_Wordpress::getUserPatronage();						
			
		// Get creator full name:
		$creator_full_name = get_option( 'patreon-creator-full-name', false );
		
		if ( !$creator_full_name OR $creator_full_name == '' ) {
			$creator_full_name = 'this creator';
		}
		
		// Get lock or not details if it is not given. If post id given, use it. 
		if ( !isset( $args['lock'] ) ) {
			
			if ( isset( $args['post_id'] ) ) {
				$lock_or_not = Patreon_Wordpress::lock_or_not( $args['post_id'] );
			}
			else {
				$lock_or_not = Patreon_Wordpress::lock_or_not();
			}
		}
		
		if ( isset( $args['post_id'] ) ) {
			$post = get_post( $args['post_id'] );
		}
		
		if ( !isset( $post ) ) {
			global $post;
		}
		
		// If lock or not details were not given, merge the incoming args with what we just got.
		if( $args AND is_array( $args ) AND !isset( $args['lock'] ) ) {
			$args = $lock_or_not + $args;
		}

		if ( $is_patron AND $args['lock'] ) {
			$label = PATREON_TEXT_UNDER_BUTTON_2;
		}
		
		if ( $args['reason'] == 'not_a_patron' ) {
			$label = PATREON_TEXT_UNDER_BUTTON_2;
		}

		if ( $args['reason'] == 'payment_declined' ) {
			$label = PATREON_TEXT_UNDER_BUTTON_3;
		}
		
		if ( $args['reason'] == 'active_pledge_not_enough' ) {
			$label = PATREON_TEXT_UNDER_BUTTON_2;			
		}
		
		if ( $args['reason'] == 'not_active_patron_at_post_date' ) {
			$label = PATREON_TEXT_UNDER_BUTTON_2;
		}
		
		
		if ( $args['reason'] == 'ppp_this_post_shown_by_age' ) {
			
			if ( $post ) {

				$articledate = get_the_time('r',$post->ID);
				
				$post_date = strtotime($articledate);	
				
				
				
				$articledate = get_the_time('r',$post->ID);
				
				$post_date = strtotime($articledate);
				
				// Get how many days are left until post is visible
				$lock_days = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );

				$unlock_date = $post_date + ($lock_days*86400) - time();
				
				$remaining_days = ceil($unlock_date/60/60/24);
	
				
				$label = $this->lang['content_will_be_public_1'] . $remaining_days  . $this->lang['content_will_be_public_2'];
				
			}
			
		}
		
		if ( $args['reason'] == 'ppp_this_post_shown_by_date' ) {
			
			if ( $post ) {
				
				// Get how many days are left until post is visible
				$lock_days = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
	
				$day_count = ceil(abs($lock_days - time())/60/60/24);
				
				$label = $this->lang['content_will_be_public_1'] . $day_count  . $this->lang['content_will_be_public_2'];
				
			}
			
		}
		
		if ( $args['reason'] == 'ppp_all_posts_of_this_type_shown_by_age' ) {
			
			if ( $post ) {
				
				$post_type = get_post_type($post_id);
				
				$articledate = get_the_time('r',$post->ID);
				
				$post_date = strtotime($articledate);

				$age = $this->opt['content_locking']['gated_post_types'][$post_type]['locking_variable'];
				
				$unlock_date = $post_date + ($age*86400) - time();
				
				$remaining_days = ceil($unlock_date/60/60/24);
			
				if ( $post ) {
										
					$label = $this->lang['content_will_be_public_1'] . $remaining_days  . $this->lang['content_will_be_public_2'];
					
					
					// Override label if the post has specific PW advanced lock:
				
					$post_level = get_post_meta( $post->ID, 'patreon-level', true );
					$patreon_active_patrons_only = get_post_meta( $post->ID, 'patreon-active-patrons-only', true );
					
					if ( $post_level >0  ) {
						
						// This has a specific lock done via PW for active patrons only. Dont show the age specific footer.
						
						$label = '';
					}
				
					
				}
			}
			
		}
		
		$post_total_patronage_level = '';
		
		if( isset( $args['post_total_patronage_level'] ) ) {
			$post_total_patronage_level = $args['post_total_patronage_level'];
		}		

		$label = str_replace( '%%creator%%', $creator_full_name, $label );
		$label = str_replace( '%%pledgelevel%%', $patreon_level, $label );
		$label = str_replace( '%%flow_link%%', Patreon_Frontend::patreonMakeCacheableFlowLink(), $label );
		$label = str_replace( '%%total_pledge%%', $post_total_patronage_level, $label );

		return $label;
		
	}
	
	public function preprocess_content_p( $content ) {
		
		global $post;
		$post_id = $post->ID;
		
		// Just bail out if this is not the main query for content and there still isnt a post id
		if ( !is_main_query() AND !$post_id ) {
			return $content;
		}
		
		if(in_array('get_the_excerpt', $GLOBALS['wp_current_filter']) OR !is_singular()) {
			
			return $content;
		}		
		
		$lock_or_not = Patreon_Wordpress::lock_or_not($post_id);
		
		if ( $lock_or_not['lock'] OR $lock_or_not['reason'] == 'valid_patron' OR $lock_or_not['reason'] == 'patron_fulfills_total_historical_pledge_requirement' ) {
			
			// Remove cb_p6 post button if content is locked or patron is valid

			global $cb_p6;
			
			if ( isset( $cb_p6->opt['post_button']['append_to_content_order'] ) ) {
	
				remove_filter( 'the_content', array($cb_p6, 'content_filters') );
				
			}
		}
		
		return $content;
	}
	public function gate_entire_content_p( $content, $post_id = false ) 
	{

		if ( $post_id ) {
			$post = get_post( $post_id );
		}
		
		// If post id is not given, try to get it from post global
		if ( !$post_id ) {
			
			global $post;
			$post_id = $post->ID;
			
		}
		
		// Just bail out if this is not the main query for content and there still isnt a post id
		if ( !is_main_query() AND !$post_id ) {
			
			return array( 
				'override' => true,
				'content' => $content,
			);
		}
		
		if(in_array('get_the_excerpt', $GLOBALS['wp_current_filter']) OR !is_singular()) {
			
			$content = $this->filter_gate_excerpts($content, $post);
	
			return array( 
				'override' => true,
				'content' => $content,
			);
		}
		
		// Now send the post id to locking decision function 
		
		$lock_or_not = Patreon_Wordpress::lock_or_not($post_id);
		
		// An array with args should be returned
		$lock = false;
		$patreon_level = 0;
		$user_patronage = 0;
		
		if ( isset( $lock_or_not['lock'] ) ) {
			$lock = $lock_or_not['lock'];			
		}
		if ( isset( $lock_or_not['patreon_level'] ) ) {
			$patreon_level = $lock_or_not['patreon_level'];
		}
		if ( isset( $lock_or_not['user_active_pledge'] ) ) {
			$user_patronage = $lock_or_not['user_active_pledge'];
		}		
		if ( isset( $lock_or_not['post_total_patronage_level'] ) ) {
			$post_total_patronage_level = $lock_or_not['post_total_patronage_level'];
		}
		
		if ( !$lock AND $lock_or_not['reason'] == 'post_is_public' ) {
			// Public content. Just return override info
			return array( 
				'override' => true,
				'content' => $content,
			);
		}
						
		if(current_user_can('manage_options')) 
		{
			return array( 
				'override' => true,
				'content' => $content . Patreon_Frontend::MakeAdminPostFooter( $patreon_level ),
			);
				
		}		
		
		$user_pledge_relationship_start = Patreon_Wordpress::get_user_pledge_relationship_start();

		if($lock) {
			$locked_content =  $this->gate_post($post,$patreon_level,$lock_or_not);
			
			// Apply PW filters so any code that uses the official filter below will still work
			return array( 
				'override' => true,
				'content' => apply_filters( 'ptrn/post_content', $locked_content, $patreon_level, $user_patronage, $lock_or_not ),
			);
				
		}
		
		return array(
				'override' => true,
				'content' => apply_filters( 'ptrn/post_content', $content .$this->make_valid_patron_footer($patreon_level, $user_patronage, $post->ID, $lock_or_not), $patreon_level, $user_patronage, $lock_or_not ),
		);
		
	}
	
	public function make_valid_patron_footer_p($patreon_level, $user_patronage, $post_id, $lock_or_not) {
		
		if(!$post_id) {
			if(in_the_loop()) {
				the_post();
				$post_id = $post->ID;
			}
			else {
				global $post;
				$post_id = $post->ID;
			}			
		}

		$post_type = get_post_type($post_id);
		
		if(isset($this->opt['content_locking']['gated_post_types'][$post_type]['locking_type']) AND $this->opt['content_locking']['gated_post_types'][$post_type]['locking_type']=='age') {
			
			$age = $this->opt['content_locking']['gated_post_types'][$post_type]['locking_variable'];
	
			// check the age of the post in days :
			$today = date('r');
			$articledate = get_the_time('r',$post_id);
			$post_age = round((strtotime($today) - strtotime($articledate))/(24*60*60),0);
						
			if($post_age >= $age) {
				
			}
			else {
				$remains = (int)$post_age-(int)$age;
				
				return $content . '<div class="patreon-valid-patron-message">This content will be patron-only in '.preg_replace("/[^0-9,.]/", "",$remains).' days</div>';
				
			}
		
		}
		
		$lock_or_not = Patreon_WordPress::lock_or_not( $post->ID );
		
		$user = wp_get_current_user();
		
		$vip                            = get_user_meta( $user->ID, 'cb_p6_a1_vip_user', true );
		$user_patreon_level             = get_user_meta( $user->ID, 'cb_p6_a1_patreon_level', true );

		if( isset( $lock_or_not['reason'] ) AND $lock_or_not['reason'] == 'user_custom_patreon_level_qualifies' ) {
			
			// Override with qualifying banner:
			
			return $content . '<div class="patreon-valid-patron-message">You have access to this content since you have special $'. $user_patreon_level .' patron status</div>';
			
		
		}
		
		if( isset( $lock_or_not['reason'] ) AND $lock_or_not['reason'] == 'user_is_vip' ) {
			
			// Override with qualifying banner:
			
			return $content . '<div class="patreon-valid-patron-message">You have access to this content since you area VIP user!</div>';
			
		
		}

		if( isset( $lock_or_not['reason'] ) AND $lock_or_not['reason'] == 'ppp_all_posts_of_this_type_shown_by_age' ) {
			
			// Already shown, no need for a specific footer
			
			return $content;
		}
		
		
		return  Patreon_Frontend::MakeValidPatronFooter($patreon_level, $user_patronage, $lock_or_not);
	
	}
	
	public function gate_post_p($post,$patronlevel,$lock_or_not) 
	{
		
		
		$gated_post_banner = $this->gated_post_banner($post,$patronlevel,$lock_or_not);
		$formatted_excerpt = '';
		if($this->opt['content_locking']['show_excerpts_for_locked_post']=='yes') {
			
			$formatted_excerpt = $this->show_excerpt_before_locked_post($post);
			
		}
		
		return $formatted_excerpt . $gated_post_banner;
	
	}
	public function show_excerpt_before_locked_post_p($post=false) {
		
		if(!$post) {
			global $post;
		}
	
		if(!isset($post->ID)) {
			
			return '';
		}
		
		if ( has_excerpt( $post->ID ) ) {
			setup_postdata( $post );
			$get_excerpt = get_the_excerpt();
			wp_reset_postdata();
		}
		else {
			$get_excerpt = $this->get_excerpt_by_id($post->ID);
		}
		
		// Check if we are in the loop, then snip the excerpt to excerpt length:
		
		if ( !is_single() ) {
			
			$excerpt_length = 35;
			
			if($this->opt['content_locking']['excerpt_before_locked_post_format_length']!=35 AND $this->opt['content_locking']['excerpt_before_locked_post_format_length']!='') {
				
				$excerpt_length = $this->opt['content_locking']['excerpt_before_locked_post_format_length'];
				
			}
			
			$original_excerpt = $get_excerpt;
			$get_excerpt = str_replace(array("\n\r", "\n", "\r"), ' ', $get_excerpt);

			$get_excerpt = preg_replace( '!\s+!', ' ',$get_excerpt);
			$words = explode(' ',rtrim($get_excerpt));
			
			$count=0;
			foreach($words as $key => $value) {

				$new_excerpt[]=$words[$key];
				$count++;

				if($count >= $excerpt_length) {
					break;				
				}

			}
			
			$get_excerpt = implode(' ', $new_excerpt);
			
			if(strlen($get_excerpt) < strlen($original_excerpt)) {
				$get_excerpt .= '...';
			}			
			
			
		}
	
		// Place excerpt in placeholder:
		$excerpt = str_replace('{%%show_excerpt_here%%}',$get_excerpt,$this->opt['content_locking']['excerpt_before_locked_post_format']);
		return do_shortcode($excerpt);
	}
	public function get_excerpt_by_id_p($post_id){
		$the_post = get_post($post_id); //Gets post ID
		$the_excerpt = $the_post->post_content; //Gets post_content to be used as a basis for the excerpt
		$original_post = $the_excerpt;
		$excerpt_length = 35; //Sets excerpt length by word count
		
		if($this->opt['content_locking']['excerpt_before_locked_post_format_length']!=35 AND $this->opt['content_locking']['excerpt_before_locked_post_format_length']!='') {
			
			$excerpt_length = $this->opt['content_locking']['excerpt_before_locked_post_format_length'];
			
		}

		$the_excerpt = strip_tags(strip_shortcodes(rtrim($the_excerpt))); //Strips tags and images then linebreaks

		
		$the_excerpt = str_replace(array("\n\r", "\n", "\r"), ' ', $the_excerpt);

		$the_excerpt = preg_replace( '!\s+!', ' ',$the_excerpt);
		$words = explode(' ',rtrim($the_excerpt));
		
		$count=0;
		foreach($words as $key => $value) {

			$new_excerpt[]=$words[$key];
			$count++;

			if($count >= $excerpt_length) {
				break;				
			}

		}
		
		$the_excerpt = implode(' ', $new_excerpt);
		
		if(strlen($the_excerpt) < strlen($original_post)) {
			$the_excerpt .= '...';
		}

		return $the_excerpt;
	}
	public function filter_patreon_shortcodes_p($output, $tag, $attr) 
	{

		global $post;
		// This function gates excerpt in content based on shortcodes
	
		if('patreon_content' != $tag AND 'patrons_only' != $tag)
		{
			return do_shortcode( $output );
		}
		if(current_user_can('manage_options')) 
		{
			return do_shortcode( $output );
		}	

		if(!isset($patreon_level) OR $patreon_level == 0)
		{
			$patreon_level = 1;
		}
		
		$gated_excerpt_banner = $this->make_gated_excerpt_banner($patreon_level);
					
		$user_patronage = Patreon_Wordpress::getUserPatronage();
		if( $user_patronage == false OR $user_patronage < ($patreon_level*100))
		{
			
			return $gated_excerpt_banner;
			
		}			

		return do_shortcode( $output );
		
	}
	public function patron_only_shortcode_p($args,$output) {

		global $post;

		// This function gates excerpt in content based on shortcodes
		
		if(current_user_can('manage_options')) {
			return do_shortcode( $output );
		}
		
		$patreon_level = @$args['level'];
		
		if(!isset($args['level']) OR $args['level']==0)
		{
			$patreon_level = 1;
		}
	
		$gated_excerpt_banner = $this->make_gated_excerpt_banner($patreon_level);

		$user_patronage = Patreon_Wordpress::getUserPatronage();
		$user = wp_get_current_user();
		
		// Default the vip status
		$vip = 'no';
		
		$vip                            = get_user_meta( $user->ID, 'cb_p6_a1_vip_user', true );
		$user_patreon_level             = get_user_meta( $user->ID, 'cb_p6_a1_patreon_level', true );
		
		if ( $user_patreon_level == '' OR !$user_patreon_level ) {
			$user_patreon_level = 0;
		}
		
		if( $user_patronage == false OR $user_patronage < ( $patreon_level*100 ) )
		{
			if ( $vip != 'yes' AND $user_patreon_level < $patreon_level ) {
				
				if ( isset($args['silent']) AND $args['silent'] == 'yes' ) {
					return '';
				}
				
				return $gated_excerpt_banner;				
			}
		}		

		return do_shortcode($output);
		
	}
	public function non_patron_only_shortcode_p($args,$output) {

		global $post;

		// This function shows whatever is inside shortcode to only non patrons
		
		if(current_user_can('manage_options')) 
		{
			// return $output;
		}
		
		$patreon_level = @$args['level'];

		$user_patronage = Patreon_Wordpress::getUserPatronage();
		$user = wp_get_current_user();
		
		// Default the vip status
		$vip = 'no';
		
		$vip                            = get_user_meta( $user->ID, 'cb_p6_a1_vip_user', true );
		$user_patreon_level             = get_user_meta( $user->ID, 'cb_p6_a1_patreon_level', true );
		
		if ( $user_patreon_level == '' OR !$user_patreon_level ) {
			$user_patreon_level = 0;
		}

		if( $user_patronage == false OR $user_patronage < ($patreon_level*100)) {

			if ( $vip != 'yes' AND $user_patreon_level == 0 ) {
				return do_shortcode( $output );
			}
		}			

		return '';
		
	}
	public function save_user_last_visited_page_before_login_p() 
	{
	
		global $post;
 
		if(is_admin())
		{
			
			setcookie( $this->internal['prefix'].'user_last_visited_page', '', 0 );
			return;
		}

		if(!is_user_logged_in() AND strpos($this->get_current_full_url(),$this->get_patreon_landing_page())===false AND (is_single($post->ID) OR is_page($post->ID)))
		{
		
			setcookie( $this->internal['prefix'].'user_last_visited_page', base64_encode(get_permalink($post->ID)), time()+(30 * 3600 * 24));
		}
		
	}
	public function get_patreon_landing_page_p()
	{
		
		$patreon_landing_page = get_option('redirect-uri',false);
		
		if($patreon_landing_page=='')
		{
			$patreon_landing_page = get_site_url().'/patreon-authorization/';
			
		}
		return $patreon_landing_page;
	}
	public function get_current_url_with_slash_p()
	{
		global $wp;
		return home_url(add_query_arg(array(),$wp->request)).'/';
	} 
	public function get_current_full_url_p()
	{
		
		$protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
		$url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		return $url;
	} 
	public function redirect_patreon_login_p($redirect_to, $request, $user) 
	{
		global $post;
		global $wp;
	

				echo '###'.$redirect_to;
			echo '<br>';
			echo '###'.$request;
			echo '<br>';
			echo '###'.home_url(add_query_arg(array(),$wp->request)).'/';
			echo '<br>';
			echo $this->get_patreon_landing_page();
			echo '<br>';
			echo '-------';
			echo '<br>';
			echo '<br>';
			echo '-------';
			echo '<br>';
			echo base64_decode($_COOKIE[$this->internal['prefix'].'user_last_visited_page']);
			echo '<br>';
			echo '-------';
			echo '<br>';
			
			wp_die();
			
					
		$patreon_landing_page = get_option('redirect-uri',false);
		
		if($patreon_landing_page=='')
		{
			$patreon_landing_page =  $this->get_patreon_landing_page();
			
		}
		if(isset($_COOKIE[$this->internal['prefix'].'user_last_visited_page'])) 
		{
			$user_last_page=base64_decode($_COOKIE[$this->internal['prefix'].'user_last_visited_page']);
		}
		else
		{
			return $redirect_to;
		}

		if(strpos($this->get_current_full_url(),$patreon_landing_page)!==false AND $_REQUEST['state']!='')
		{
			if(isset($_COOKIE[$this->internal['prefix'].'user_last_visited_page'])) 
			{
			
				return $user_last_page;
			}
			else
			{
				return $redirect_to;
			}
			
	
			
		}
	
		return $redirect_to;
		
	}
	public function filter_gate_excerpts_p($excerpt,$post) 
	{
		
		if($this->opt['content_locking']['gate_excerpts_in_listings']!='yes') {
			
			return $excerpt;
			
		}
	
		if(current_user_can('manage_options')) {
			return $excerpt;
		}
				
		$marked = get_post_meta( $post->ID, 'marked_patron_only', true );
		
		$lock_or_not = Patreon_WordPress::lock_or_not( $post->ID );

		$post_type = get_post_type();
		
		if(!isset($this->opt['content_locking']['gated_post_types']) OR !is_array($this->opt['content_locking']['gated_post_types'])) {
			$this->opt['content_locking']['gated_post_types']=array();
		}
		
		if( $marked=='yes' OR $lock_or_not['lock'] OR $this->opt['content_locking']['entire_site_patron_only']=='yes' OR in_array($post_type,$this->opt['content_locking']['gated_post_types'])) {
			
			// We are told to filter content from posts which are marked patron only
			
			$gated_excerpt_banner = $this->make_listing_gated_excerpt_banner($lock_or_not['patreon_level'], $post->ID);
			
			return $gated_excerpt_banner;
			
		}
		// This function gates excerpt in content based on shortcodes
		
		return $excerpt;
		
	}
	public function make_gated_excerpt_banner_p($patreon_level)
	{
		
		$gated_post_banner = $this->load_template('patron_only_content_for_excerpt');
		
		$gated_post_banner = $this->process_lang($gated_post_banner);
			
		// Process the internal ids and replacements
			
		$gated_post_banner = $this->process_vars_to_template($this->internal, $gated_post_banner,array('prefix','id'));
		
		// If the custom banner image is selected, use it. else use default:
		
		if($this->opt['content_locking']['custom_excerpt_button']!='')
		{
		
			
			$button='<img src="'.$this->opt['content_locking']['custom_excerpt_button'].'" style="max-width:'.$this->opt['content_locking']['custom_excerpt_button_width'].'px;height:auto;width:100%;" />';
		}
		else
		{
			$button='<img src="'.$this->internal['plugin_url'].'plugin/templates/default/be_our_patron_excerpt.png" style="max-width:'.$this->opt['content_locking']['custom_excerpt_button_width'].'px;height:auto;width:100%;" />';
			
		}
		
		if($this->opt['content_locking']['custom_patron_only_excerpt_heading']!='')
		{
			$heading=$this->opt['content_locking']['custom_patron_only_excerpt_heading'];
			
			$heading = str_replace("***patreonlevelrequirement***",$patreon_level,$heading);
		}
		else
		{
		
			
			if(isset($patreon_level))
			{
		
				$heading=$this->lang['this_content_is_patron_only_excerpt_level'];
				
				$heading = str_replace("***patreonlevelrequirement***",$patreon_level,$heading);
				
				// Put patreon level:
				
				
			}
			else
			{
				$heading=$this->lang['this_content_is_patron_only_excerpt'];
			}			
			
		}
		if($this->opt['content_locking']['patron_only_excerpt_heading_bold']=='yes')
		{
			$weight='bold';
			
		}
		else
		{
			
			$weight='normal';
		}

			
		$newwindow='';
		
		
		$get_creator_id = get_option('patreon-creator-id',true);
		
		$target_url = $this->append_params_to_url(Patreon_Frontend::MakeUniversalFlowLink($patreon_level*100));
		
		// We have to modify the $ amount in the url otherwise the complex lock or not logic and filters added could set the $ amount to 0 if they see the post in which the excerpt is present is unlocked.
		
		$parsed_url = parse_url($target_url);

		parse_str($parsed_url['query'],$query);

		$query['min_cents'] = $patreon_level * 100;
		
		$query = http_build_query($query);
	
		$target_url = $parsed_url['scheme'].'://'.$parsed_url['host'].$parsed_url['path'].'?'.$query;
		
		$vars=array(
		
			'banner_image' => $button, 
			'patron_only_excerpt_heading_font_size' => $this->opt['content_locking']['patron_only_excerpt_heading_font_size'], 
			'this_content_is_patron_only_notification' => $heading, 
			'patron_only_excerpt_heading_font_weight' => $weight, 
			'custom_excerpt_button_margin' => $this->opt['content_locking']['custom_excerpt_button_margin'],
			'patron_only_excerpt_padding' => $this->opt['content_locking']['patron_only_excerpt_padding'],
			'targetblankornot' => $newwindow,
			'target_patreon_url' => $target_url,
			'background_color' => $this->opt['content_locking']['patron_only_excerpt_background_color'],
		
		);
		
		$gated_post_banner = $this->process_vars_to_template($vars, $gated_post_banner);
		
		return $gated_post_banner;		
	}
	public function make_to_patreon_link_p($patreon_level, $post)
	{
		
		if($this->opt['content_locking']['put_users_to_pipeline']=='yes')
		{
			$target_url=Patreon_Frontend::MakeUniversalFlowLink($patreon_level*100, false, false, $post);
		
		}
		else
		{
			global $cb_p6;
			
			$target_url='https://www.patreon.com/'.$cb_p6->opt['quickstart']['site_account'];
		}
		
		return $target_url;
		
	}
	public function make_listing_gated_excerpt_banner_p($patreon_level, $post_id)
	{

		$gated_post_banner = $this->load_template('patron_only_content_for_excerpt_listings');
		
		$gated_post_banner = $this->process_lang($gated_post_banner);
			
		// Process the internal ids and replacements
			
		$gated_post_banner = $this->process_vars_to_template($this->internal, $gated_post_banner,array('prefix','id'));
		
		// If the custom banner image is selected, use it. else use default:
		
		if($this->opt['content_locking']['custom_excerpt_listing_button']!='')
		{
		
			
			$button='<img src="'.$this->opt['content_locking']['custom_excerpt_listing_button'].'" style="max-width:'.$this->opt['content_locking']['custom_excerpt_listing_button_width'].'px;height:auto;width:100%;" />';
		}
		else
		{
			$button='<img src="'.$this->internal['plugin_url'].'plugin/templates/default/be_our_patron_excerpt.png" style="max-width:'.$this->opt['content_locking']['custom_excerpt_listing_button_width'].'px;height:auto;width:100%;" />';
			
		}
		
		if($this->opt['content_locking']['custom_patron_only_excerpt_listing_heading']!='')
		{
			$heading=$this->opt['content_locking']['custom_patron_only_excerpt_listing_heading'];
			
		}
		else
		{
			
			$lock_or_not = Patreon_WordPress::lock_or_not( $post_id );
			// Add post id to args:
			
			$lock_or_not['post_id'] = $post_id;
			
			$heading = Patreon_Frontend::getLabelOverUniversalButton( $patreon_level, $lock_or_not );
					
		}
		if($this->opt['content_locking']['patron_only_excerpt_listing_heading_bold']=='yes')
		{
			$weight='bold';
			
		}
		else
		{
			
			$weight='normal';
		}
		
			
		$newwindow='';
	
		$get_creator_id = get_option('patreon-creator-id',true);
		
		if(!$patreon_level OR $patreon_level ==0)
		{
			$patreon_level = 1;
		}
		
		$target_url = $this->append_params_to_url($this->make_to_patreon_link($patreon_level,get_post($post_id)));
		
		if ( $this->opt['content_locking']['custom_excerpt_listing_button_show']!='yes' ) {
			$button = '';
		}
		
		$vars=array(
		
			'banner_image' => $button, 
			'patron_only_excerpt_listing_heading_font_size' => $this->opt['content_locking']['patron_only_excerpt_listing_heading_font_size'],
			'this_content_is_patron_only_notification' => $heading, 
			'patron_only_excerpt_listing_heading_font_weight' => $weight, 
			'custom_excerpt_listing_button_margin' => $this->opt['content_locking']['custom_excerpt_listing_button_margin'],
			'patron_only_excerpt_listing_padding' => $this->opt['content_locking']['patron_only_excerpt_listing_padding'],
			'custom_excerpt_listing_banner_wrapper_horizontal_alignment' => $this->opt['content_locking']['custom_excerpt_listing_banner_wrapper_horizontal_alignment'],
			'targetblankornot' => $newwindow,
			'target_patreon_url' => $target_url,
		
		);
		$gated_post_banner = $this->process_vars_to_template($vars, $gated_post_banner);
		
		$formatted_excerpt = '';
		if($this->opt['content_locking']['show_excerpts_for_locked_post']=='yes') {
			
			$formatted_excerpt = $this->show_excerpt_before_locked_post(get_post($post_id));
			
		}
		
		return $formatted_excerpt . $gated_post_banner;		
	}
	public function gated_post_banner_p($v1,$v2,$v3)
	{
		$post=$v1;
		$patronlevel=$v2;
		$args=$v3;
		
		// Get the post from post id if it is supplied
		if ( isset( $args['post_id'] ) ) {
			$post = get_post( $args['post_id'] );			
		}
		
		if ( !$args OR !is_array( $args ) ) {
			$args = array();
		}
		
		$gated_post_banner = $this->load_template('patron_only_content_for_entire_post');
		
		$gated_post_banner = $this->process_lang($gated_post_banner);
			
		// Process the internal ids and replacements
			
		$gated_post_banner = $this->process_vars_to_template($this->internal, $gated_post_banner,array('prefix','id'));
		
		if($this->opt['content_locking']['custom_patron_only_heading']!='' AND $this->opt['content_locking']['custom_patron_only_heading']!=$this->lang['this_content_is_patron_only'])
		{
			$banner = stripslashes($this->opt['content_locking']['custom_patron_only_heading']);
			
		}
		else
		{
	
			if(isset($patronlevel) AND $patronlevel>1)
			{
				$banner = $this->lang['this_content_is_patron_only_no_level'];
					
				if(get_option('patreon-custom-universal-banner','')!='')
				{
					$banner = get_option('patreon-custom-universal-banner','');
				}
				
			}
			else
			{
				$banner = $this->lang['this_content_is_patron_only'];
			}
		
		}
		
		$patron_only_custom_banner = get_post_meta($post->ID, 'patron_only_custom_banner', true);

		// If custom patreon banner for this post exists, use it.

		if(empty($patron_only_custom_banner ) == false) 
		{
			$banner =  $patron_only_custom_banner;
		}	

		// Put patreon level:
		$banner = str_replace("%%pledgelevel%%",$patronlevel,$banner);
		$banner = str_replace("***patreonlevelrequirement***",$patronlevel,$banner);

		// Apply Patreon WordPress filters for compatibility
		$banner = apply_filters( 'ptrn/contribution_required', $banner, 'main_banner_message',$patronlevel, $post );
		
		$banner = apply_filters( 'ptrn/final_state_main_banner_message', $banner , $patronlevel, $post );
	
		$button_args = array();
		
		
		if ( isset( $args['direct_unlock'] ) ) {
			
			// This is a direct unlock intent that does not seek to particularly unlock a post. It can be anything. Set the relevant vars for universal button function:
			$button_args['direct_unlock'] = $args['direct_unlock'];
			$button_args['redirect'] = $args['redirect'];
			
		}

		// If the custom button image is selected, use it. else use default:
		
		if($this->opt['content_locking']['custom_button']!='')
		{
		
			$button='<img src="'.$this->opt['content_locking']['custom_button'].'" style="max-width:'.$this->opt['content_locking']['custom_button_width'].'px;height:auto;width:100%;" />';
		}
		else
		{
			$label_text = Patreon_Frontend::patreonMakeUniversalButtonLabel();
			$button= Patreon_Frontend::patreonMakeUniversalButtonImage($label_text);
			
		}		
		
		if($this->opt['content_locking']['patron_only_heading_bold']=='yes')
		{
			$weight='bold';
			
		}
		else
		{
			
			$weight='normal';
		}
		
		$newwindow='';
		
		
		$target_url =  Patreon_Frontend::MakeUniversalFlowLink($patronlevel*100);
		
		$get_creator_id = get_option('patreon-creator-id',true);
		
		$button 	   = apply_filters( 'ptrn/final_state_universal_button', $button , $patronlevel, $post );
				
		$text_over_universal_button  = apply_filters( 'ptrn/final_state_label_over_universal_button', Patreon_Frontend::getLabelOverUniversalButton( $patronlevel, $args ), $patronlevel, $post );
		$text_under_universal_button = apply_filters( 'ptrn/final_state_label_under_universal_button', Patreon_Frontend::getLabelUnderUniversalButton( $patronlevel, false, false, $args ), $patronlevel, $post );		
		
		$vars = array(
		
			'button' => $button, 
			'patron_only_heading_font_size' => $this->opt['content_locking']['patron_only_heading_font_size'], 
			'this_content_is_patron_only_notification' => $banner, 
			'patron_only_heading_font_weight' => $weight, 
			'patron_only_content_padding' => $this->opt['content_locking']['patron_only_content_padding'], 
			'custom_button_margin' => $this->opt['content_locking']['custom_button_margin'],
			'targetblankornot' => $newwindow,
			'target_patreon_url' => $target_url,
			'text_over_universal_button' => $text_over_universal_button,
			'text_under_universal_button' => $text_under_universal_button,
		
		);
		
		$gated_post_banner = $this->process_vars_to_template($vars, $gated_post_banner);

		return $gated_post_banner;		
	}
	public function add_custom_banner_editor_p($post) 
	{
	
		$my_meta_content = get_post_meta($post->ID, 'patron_only_custom_banner', TRUE);
		if (!$my_meta_content) $my_meta_content = '';
		wp_editor( $my_meta_content, 'patron_only_custom_banner', array('textarea_rows' => '5'));

	}
	public function add_patron_only_meta_box_p( ) 
	{
		add_action( 'add_meta_boxes', array(&$this,'add_patron_only_meta_boxes' ));
	}
	public function add_custom_banner_meta_box_p( ) 
	{	
		$post_types = get_post_types();
		
		foreach ($post_types  as $page )
		{
			add_meta_box(
				'patron-only-custom-banner',      // Unique ID
				$this->lang['custom_banner_label'],    // Title
				array(&$this,'add_custom_banner_editor'),   // Callback function
				$page,         // Admin page (or post type)
				'default'
			);				
		}
	}
	public function add_patron_only_meta_boxes_p() 
	{
		$post_types = get_post_types();
		
		foreach ($post_types  as $page )
		{
			add_meta_box(
				'patron-only-meta-box',      // Unique ID
				$this->lang['patron_only_label'],    // Title
				array(&$this,'patron_only_meta_box'),   // Callback function
				$page,         // Admin page (or post type)
				'side',         // Context
				'default'         // Priority
			);
			add_meta_box(
				'patron-only-advanced-meta-box',      // Unique ID
				$this->lang['patron_only_advanced_label'],    // Title
				array(&$this,'patron_only_advanced_meta_box'),   // Callback function
				$page,         // Admin page (or post type)
				'side',         // Context
				'default'         // Priority
			);			
				
		}

	}
	public function patron_only_meta_box_p() 
	{
		global $post;

		 $marked = get_post_meta( $post->ID, 'marked_patron_only', true );
	
			if( $marked=='yes')
			{
				$checked=' checked="CHECKED"';
				
			}
			else
			{
				$checked='';
				
			}
			echo '<p>'.$this->lang['mark_metabox_info'].'</p>';
		  
		  ?>

		<p>
			<label for="mark_patron_only"><?php echo $this->lang['title_mark_patron_only_metabox'] ?></label>&nbsp;
			<input class="widefat" type="checkbox" name="marked_patron_only" id="mark_patron_only" value="yes" <?php echo $checked ?> />
		</p>
		<?php
	}
	public function patron_only_advanced_meta_box_p() 
	{
		global $post;

		$marked = get_post_meta( $post->ID, 'ppp_advanced_patron_only', true );
	
		if( $marked=='yes')
		{
			$checked=' checked="CHECKED"';
			
		}
		else
		{
			$checked='';
			
		}
		echo '<p>'.$this->lang['mark_metabox_advanced_info'].'</p>';
		  
		?>
			
			<select id="cb_p6_a1_post_locking_format_metabox_toggle" name="ppp_advanced_post_locking">
				
				<option value="nochange">No change</option>
				<option value="date">Lock after date</option>
				<option value="show_date">Show after date</option>
				<option value="age">Lock this post after (X) days</option>
				<option value="show_age">Show this post after (X) days</option>
			
			</select>
	
			
			<div id="cb_p6_a1_post_locking_format_date" class="cb_p6_a1_locking_format_selector">
				<?php
				
					echo $this->make_date_select(
		
						$date_args=array(
							'title'=>$this->lang['advanced_start_date'],
							'template'=>'date_select_vertical',
							'default_month_value'=>'-',
							'default_year_value'=>'-',
							'default_day_value'=>'-',
							'default_day_label'=>'-',
							'default_year_label'=>'-',
							'default_month_label'=>'-',
							'select_name_day'=>'ppp_advanced_post_locking_date[start_day]',
							'select_name_month'=>'ppp_advanced_post_locking_date[start_month]',
							'select_name_year'=>'ppp_advanced_post_locking_date[start_year]',
			
						)
					);
				?>
			</div>
			<div id="cb_p6_a1_post_locking_format_show_date" class="cb_p6_a1_locking_format_selector">
				<?php
					echo $this->make_date_select(
		
						$date_args=array(
							'title'=>$this->lang['advanced_end_date'],
							'template'=>'date_select_vertical',
							'default_month_value'=>'-',
							'default_year_value'=>'-',
							'default_day_value'=>'-',
							'default_day_label'=>'-',
							'default_year_label'=>'-',
							'default_month_label'=>'-',
							'select_name_day'=>'ppp_advanced_post_locking_date[end_day]',
							'select_name_month'=>'ppp_advanced_post_locking_date[end_month]',
							'select_name_year'=>'ppp_advanced_post_locking_date[end_year]',
			
						)
					);
		
				?>
			</div>
				
			<div id="cb_p6_a1_post_locking_format_age" class="cb_p6_a1_locking_format_selector">
				<b>Lock these posts <input type="text" style="width : 50px" name="ppp_advanced_post_locking_info_lock" value="7"> days after they are published</b>
			
			</div>	
			<div id="cb_p6_a1_post_locking_format_show_age" class="cb_p6_a1_locking_format_selector">
				<b>Show these posts to anyone <input type="text" style="width : 50px" name="ppp_advanced_post_locking_info_show" value="7"> days after they are published</b>
			</div>		
			
			<div id="cb_p6_a1_post_locking_value">
				
				<b>Minimum $ value to be able to see the posts </b><input type="text" style="width : 50px" name="post_locking_value" value="0">
			</div>
			
			<h4>Current locking type and value</h4>
			<?php
			
				$format = get_post_meta( $post->ID, 'ppp_advanced_post_locking', true );
				$info = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
				$lock_value = get_post_meta( $post->ID, 'ppp_advanced_post_locking_value', true );
				
				if($format!='nochange' AND $format!='') {
	
					if($format=='date') {
						echo 'Lock after '.date("F j, Y",$info); 
					}
					if($format=='show_date') {
						echo 'Show after '.date("F j, Y",$info); 
					}
					if($format=='age') {
						echo 'Lock after '.$info.' days';
					}
					if($format=='show_age') {
						echo 'Show after '.$info.' days';
					}
					echo '<br />';
					echo 'Min. pledge required: $'.$lock_value;
					
					?>
			
					<h4>Make post Public again (remove advanced Patron only locking)</h4>
					
					<select name="remove_advanced_post_locking"><option selected value="nochange">No Change</option><option value="remove">Remove</option></select>
					<br><br>
					If you select 'Remove' above, post-specific advanced locking setting will be removed. If you have set any gating level at 'Patreon Level' box, or marked the 'Patron Only' checkbox, they will still remain active. Also, if there are settings that affect entire site or this post type, they will still remain active. To change them, go to your Patron Plugin Pro admin page's 'Content Locking' section.
					<br>
			
				<?php
					
				}
				else {
					echo 'No advanced locking rule currently exists...';
				}
			
			
	}
	public function filter_cb_p6_link_p($link,$patreon_level=false)
	{
		if(!$patreon_level OR $patreon_level == 0)
		{
			$patreon_level = 1;
		}
		
		if($this->opt['content_locking']['put_users_to_pipeline']=='yes')
		{
			// Override cb_p6 links:
			return 	$this->make_to_patreon_link($patreon_level);
		
		}
		else
		{
			return $link;
		}
		
	}
	public function auto_get_patreon_creator_id_p()
	{

		/* update Patreon creator ID on page load */
		if(get_option('patreon-client-id', false) && get_option('patreon-client-secret', false) && get_option('patreon-creators-access-token', false)) {
	
			$creator_id = Patreon_Wordpress::getPatreonCreatorID();

			if($creator_id != false) {
	
				update_option( 'patreon-creator-id', $creator_id );
			}

		}
    }
	public function append_params_to_url_p($link)
	{
		// For now we cant do that because patreon doesnt recognize urls with parameters
		
		//$link = remove_query_arg( 'utm_content',  $link );
		
		//$link = add_query_arg( 'utm_content', 'patron_plugin_pro_link', $link );
		
		return $link;
		
	}
	public function save_post_metas_p() 
	{
		global $post;
		
		if(!isset($post))
		{
			// General situation, post doesnt exist. See if user has general post edit capability:
			if ( !current_user_can( 'edit_posts') )
			return;	
			
		}
		else
		{
			// Post id exists. check if current user can edit this post type
			$post_id = $post->ID;
			
			/* Get the post type object. */
			$post_type = get_post_type_object( $post->post_type );

			/* Check if the current user has permission to edit the post. */
			if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
			return $post_id;			
			
		}
	

		if(isset($this->internal['post_metas']) AND count($this->internal['post_metas'])>0)
		{
			// All ok. There are post metas to process
		 
		  
		}
		else
		{
			// No post meta. return.
			return;
		}
		
		// If the post id is not there yet (post not saved) then just return
		
		if(!isset($post_id))
		{
			return;
		}

		$metas = $this->internal['post_metas'];

		foreach($metas as $key => $value)
		{
			
			$new_meta_value = ( isset( $_POST[$key] ) ? $_POST[$key]  : '' );
			
			/* Get the meta key. */
			$meta_key = $key;

			/* Get the meta value of the custom field key. */
			$meta_value = get_post_meta( $post_id, $meta_key, true );
						
			if($meta_key != 'ppp_advanced_post_locking') {
				
				/* If a new meta value was added and there was no previous value, add it. */
				if ( $new_meta_value && '' == $meta_value )
				add_post_meta( $post_id, $meta_key, $new_meta_value, true );

				/* If the new meta value does not match the old value, update it. */
				elseif ( $new_meta_value && $new_meta_value != $meta_value )
				update_post_meta( $post_id, $meta_key, $new_meta_value );

				/* If there is no new meta value but an old value exists, delete it. */
				elseif ( '' == $new_meta_value && $meta_value )
				delete_post_meta( $post_id, $meta_key, $meta_value );
			
			}

			// Check if advanced post locking was set
			if($meta_key == 'ppp_advanced_post_locking' AND isset($_REQUEST['ppp_advanced_post_locking']) AND $_REQUEST['ppp_advanced_post_locking']!='nochange' AND $_REQUEST['ppp_advanced_post_locking']!='') {
	
				// Advanced locking request. Take care of it:
				
				delete_post_meta( $post_id, 'ppp_advanced_post_locking_info');
				delete_post_meta( $post_id, 'ppp_advanced_post_locking_value');
				
				if($_REQUEST['ppp_advanced_post_locking']=='age') {
					
					$info = $_REQUEST['ppp_advanced_post_locking_info_lock'];
					
				}
				if($_REQUEST['ppp_advanced_post_locking']=='show_age') {
					
					$info = $_REQUEST['ppp_advanced_post_locking_info_show'];
					
				}
				
				if($_REQUEST['ppp_advanced_post_locking']=='date' AND $_REQUEST['ppp_advanced_post_locking_date']['start_year']!='-' AND $_REQUEST['ppp_advanced_post_locking_date']['start_day']!='-' AND $_REQUEST['ppp_advanced_post_locking_date']['start_month']!='-' ) {
					
					$info = mktime(0,0,0,$_REQUEST['ppp_advanced_post_locking_date']['start_month'],$_REQUEST['ppp_advanced_post_locking_date']['start_day'],$_REQUEST['ppp_advanced_post_locking_date']['start_year']);
					
				}
				if($_REQUEST['ppp_advanced_post_locking']=='show_date' AND $_REQUEST['ppp_advanced_post_locking_date']['end_year']!='-' AND $_REQUEST['ppp_advanced_post_locking_date']['end_day']!='-' AND $_REQUEST['ppp_advanced_post_locking_date']['end_month']!='-') {
					
					$info = mktime(0,0,0,$_REQUEST['ppp_advanced_post_locking_date']['end_month'],$_REQUEST['ppp_advanced_post_locking_date']['end_day'],$_REQUEST['ppp_advanced_post_locking_date']['end_year']);
				
				}
				update_post_meta( $post_id, 'ppp_advanced_post_locking',$_REQUEST['ppp_advanced_post_locking'] );
				update_post_meta( $post_id, 'ppp_advanced_post_locking_value',$_REQUEST['post_locking_value'] );
				update_post_meta( $post_id, 'ppp_advanced_post_locking_info', $info );
				update_post_meta( $post_id, 'ppp_advanced_post_locking_date', $_REQUEST['ppp_advanced_post_locking_date'] );
			}
			if($meta_key == 'remove_advanced_post_locking' AND isset( $_REQUEST['remove_advanced_post_locking'] ) AND $_REQUEST['remove_advanced_post_locking'] == 'remove') {

				delete_post_meta( $post_id, 'ppp_advanced_post_locking');
				delete_post_meta( $post_id, 'ppp_advanced_post_locking_info');
				delete_post_meta( $post_id, 'ppp_advanced_post_locking_value'); 
				delete_post_meta( $post_id, 'ppp_advanced_post_locking_date'); 
				
			}
				
		}
		
	}
	public function make_date_select_p($v1=false)
	{
		$args = $v1;
		
		if(isset($args['start_year']))
		{
			$start_year=$args['start_year'];
		}
		else
		{
			$start_year=1900;
		}
		
		if(isset($args['end_year']))
		{
			$end_year=$args['end_year'];
			
		}
		else
		{
			$end_year=date("Y");
		}
		
		$load_template = 'date_select';
		
		if(isset($args['template'])) {
			$load_template = $args['template'];
		}
		
		$date_template = $this->load_template($load_template);
		
		$date_template = $this->process_lang($date_template);
			
		// Process the internal ids and replacements
			
		$date_template = $this->process_vars_to_template($this->internal, $date_template,array('prefix','id'));		
		
		// Make days:
		
		$counter=1;
		$days='';
		while($counter<=31)
		{
			// 
			if($counter<10) {
				// Slap a zero
				$day_count='0'.$counter;
				
			}
			else {
				$day_count=$counter;
			}
			$day_label=$counter;
			if(isset($this->lang['day_of_month_'.$day_count]) AND $this->lang['day_of_month_'.$day_count]!='')
			{
				// Why did we do this? because we want languages which dont use roman numerals to be able to have day translations coming from language file.
				
				// If it exists, override label:
				
				$day_label=$this->lang['day_of_month_'.$day_count];
				
				
			}
			$selected ='';
			if(isset($args['selected_day']) AND $args['selected_day'] == $day_count)
			{
				$selected = " selected";
			}
			
			$days.='<option value="'.$day_count.'"'.$selected.'>'.$day_label.'</option>';
			
			$counter++;
		}
		
		// Do months
		$counter=1;
		$months='';		
		while($counter<=12)
		{
			// 
			if($counter<10)
			{
				// Slap a zero
				$month_count='0'.$counter;
				
			}
			else
			{
				$month_count=$counter;
			}
			$month_label=$counter;
			if(isset($this->lang['month_'.$month_count]) AND $this->lang['month_'.$month_count]!='')
			{
				// Why did we do this? because we want languages which dont use roman numerals to be able to have month translations coming from language file. Also we will put default language there
				
				// If it exists, override label:
				
				$month_label=$this->lang['month_'.$month_count];
				
			}
			$selected ='';
			if(isset($args['selected_month']) AND $args['selected_month'] == $month_count)
			{
				$selected = " selected";
			}			
			$months.='<option value="'.$month_count.'"'.$selected.'>'.$month_label.'</option>';
			
			$counter++;
		}
		
		// Do years
		$counter=$end_year;

		$years='';		
		while($counter>=$start_year)
		{

			$year_label=$counter;
			if(isset($this->lang['year_'.$counter]) AND $this->lang['year_'.$counter]!='')
			{
				// Anyone wanting to use non numeral years may be quite unlikely, but just in case.
				
				// If it exists, override label:
				
				$year_label = $this->lang['year_'.$counter];
				
			}
			$selected ='';
			if(isset($args['selected_year']) AND $args['selected_year'] == $counter)
			{
				$selected = " selected";
			}			
			$years.='<option value="'.$counter.'"'.$selected.'>'.$year_label.'</option>';
			
			$counter--;
		}
		if(isset($args['fieldset_class']))
		{
			$fieldset_class=$args['fieldset_class'];
		}
		else
		{
			$fieldset_class='date_fieldset';
		}
		
		if(isset($args['title']))
		{
			$title=$args['title'];
		}
		else
		{
			$title=$this->lang['date'];
		}
		
		if(isset($args['label_month']))
		{
			$label_month=$args['label_month'];
		}
		else
		{
			$label_month=$this->lang['month'];
		}
		
		if(isset($args['id_month']))
		{
			$id_month=$args['id_month'];
		}
		else
		{
			$id_month='id_month';
		}
		
		if(isset($args['select_name_month']))
		{
			$select_name_month=$args['select_name_month'];
		}
		else
		{
			$select_name_month='select_month';
		}
		
		
		if(isset($args['label_day']))
		{
			$label_day=$args['label_day'];
		}
		else
		{
			$label_day=$this->lang['day'];
		}
		
		if(isset($args['id_day']))
		{
			$id_day=$args['id_day'];
		}
		else
		{
			$id_day='id_day';
		}
		
		if(isset($args['select_name_day']))
		{
			$select_name_day=$args['select_name_day'];
		}
		else
		{
			$select_name_day='select_day';
		}
		
		if(isset($args['label_year']))
		{
			$label_year=$args['label_year'];
		}
		else
		{
			$label_year=$this->lang['year'];
		}
		
		if(isset($args['id_year']))
		{
			$id_year=$args['id_year'];
		}
		else
		{
			$id_year='id_year';
		}
		
		if(isset($args['select_name_year']))
		{
			$select_name_year=$args['select_name_year'];
		}
		else
		{
			$select_name_year='select_year';
		}
		
		if(isset($args['default_year_value']) AND isset($args['default_year_label']) ) {
			$years='<option value="'.$args['default_year_value'].'">'.$args['default_year_label'].'</option>'.$years;
		}
		if(isset($args['default_month_value']) AND isset($args['default_month_label']) ) {
			$months='<option value="'.$args['default_month_value'].'">'.$args['default_month_label'].'</option>'.$months;
		}
		if(isset($args['default_day_value']) AND isset($args['default_day_label']) ) {
			$days='<option value="'.$args['default_day_value'].'">'.$args['default_day_label'].'</option>'.$days;
		}
		
		$vars=array(
		
			'months' => $months, 
			'days' => $days, 
			'years' => $years, 
			'fieldset_class' => $fieldset_class, 
			'title' => $title, 
			'label_year' => $label_year, 
			'id_year' => $id_year, 
			'select_name_year' => $select_name_year, 
			'label_month' => $label_month, 
			'id_month' => $id_month, 
			'select_name_month' => $select_name_month, 
			'label_day' => $label_day,
			'id_day' => $id_day, 
			'select_name_day' => $select_name_day, 
			
		);
		
		$date_template = $this->process_vars_to_template($vars, $date_template);
				
		return $date_template;
	}
 	public function modify_protected_post_types_p($ze_array) {
		
		// return empty array to enable level metabox in all post types
		
		return array();
		
	}
 	public function showPatreonButton_p() {

		global $wp;

		$client_id = get_option('patreon-client-id', false);

		if($client_id == false) {
			return '';
		}

		$href = $this->patreonMakeLoginLink($client_id);
		
		echo '<div class="patreon-login-refresh-button">'.Patreon_Frontend::patreonMakeLoginButton().'</div>';
	
	}
	public function patreonMakeLoginLink_p($client_id=false,$state=false,$post=false) {
		
		if(!$post)
		{
			global $post;
		}
		
		if(!$client_id)
		{
			$client_id = get_option('patreon-client-id', false);
		}
		
			$redirect_uri = site_url().'/patreon-authorization/';
		// If we werent given any state vars to send, initialize the array
		if(!$state)
		{
			$state=array();
		
			// Get the address of the current page, and save it as final redirect uri.		
			// Start with home url for redirect. If post is valid, get permalink. 
			
			$final_redirect = home_url();
			
			if($post)
			{
				$final_redirect = get_permalink($post->ID);
			}
			
			// We dont want to redirect people to login page. So check if we are there.
			if ( $GLOBALS['pagenow'] === 'wp-login.php' ) {
				
				$final_redirect = site_url();
			}			
			
			$state['final_redirect_uri'] = $final_redirect;			
			
		}
		
		// Add the patreon nonce that was set via init function to vars.
		$state['patreon_nonce']=$_COOKIE['patreon_nonce'];
		
		$redirect_uri = site_url().'/patreon-authorization/';

		$href = 'https://www.patreon.com/oauth2/authorize?response_type=code&client_id='.$client_id.'&redirect_uri='.$redirect_uri.'&state='.base64_encode(serialize($state));
	
		return apply_filters('ptrn/login_link', $href);
	}
	public function patreonMakeLoginButton_p($client_id=false) {
		
		if(!$client_id)
		{
			$client_id = get_option('patreon-client-id', false);
		}
		
		// Check if user is logged in to WP, for determination of label text
		
		// Set login label to default
		$login_label =  apply_filters('ptrn/login_button_label',PATREON_TEXT_CONNECT);
		
		if(is_user_logged_in()){
			// User is logged into WP. Check if user has valid patreon data :
			
			$user = wp_get_current_user();

			if($user) {
				
				$user_response = Patreon_Wordpress::getPatreonUser($user);
				// ^ REVISIT - whats above may be a concern - it connects to API to check for valid user for every generation of button. If we could cache it it would be better

				if($user_response) {
					// This is a user logged into Patreon. use refresh text
					$login_label = PATREON_TEXT_REFRESH;
				}					
			}
			
		}
		
		$href = $this->patreonMakeLoginLink($client_id);

		return apply_filters('ptrn/login_button', '<a href="'.$href.'" class="ptrn-login" data-ptrn_nonce="' . wp_create_nonce( 'patreon-nonce' ).'"><div class="patreon-responsive-button-wrapper"><div class="patreon-responsive-button"><img class="patreon_logo" src="'.PATREON_PLUGIN_ASSETS.'/img/patreon-logomark-on-coral.svg" alt=""> '.$login_label.'</div></div></a>', $href);

	}
	public function turn_strict_oauth_off($strict)
	{
		return false;
	}
	public function hook_into_patreon_user_creation_and_login_process_p($args)
	{
		// This is the case for a new user logging in via Patreon. We check for this here because we need the tokens and also we need the user creation process undisturbed.
		
		$user = $args['user'];
		
		$user_patronage = Patreon_WordPress::getUserPatronage($user);
	
		if($user_patronage < $this->opt['content_locking']['only_patrons_with_amount']*100) {
	
			$message_1 = $this->lang['only_patrons_login_message_1'];			
			$message_2 = $this->lang['only_patrons_login_message_2'];			
			
			if(isset($this->opt['content_locking']['only_patrons_login_message_1']) AND
				$this->opt['content_locking']['only_patrons_login_message_1']!='') {
				
				$message_1 = $this->opt['content_locking']['only_patrons_login_message_1'];	
					
			}

			if(isset($this->opt['content_locking']['only_patrons_login_message_2']) AND
				$this->opt['content_locking']['only_patrons_login_message_2']!='') {
					
				$message_2 = $this->opt['content_locking']['only_patrons_login_message_2'];
					
			}
					
			$message = $message_1.$this->opt['content_locking']['only_patrons_with_amount'].$message_2;

			$redirect_url = wp_login_url();
			$redirect_url = add_query_arg( 'patreon_message', 'patreon_weird_redirection_at_login', $redirect_url);					
			$redirect_url = add_query_arg( 'patron_pro_override_error_message', urlencode($message), $redirect_url);
			
			wp_logout();
			wp_redirect($redirect_url);
			exit;
		}		
		
	}
	public function hook_into_login_process_p($username, $user)
	{
	
		if($this->opt['content_locking']['only_patrons_with_amount']<=0) {
			
			return $username;
		}
		
		if(is_wp_error($username)) {
			return $username;
		}
		
		$current_user = get_user_by('login',$username);

		if($this->is_user_wp_admin($current_user->ID)) {
			return $username;		
		}

		foreach( $current_user->roles as $key => $value ) {
			
			if(isset($this->opt['content_locking']['always_login_allowed_roles'][$current_user->roles[$key]])) {
				return $username;
			}
			
		}
		
		if ( $_REQUEST['code'] != '' AND strpos( $_SERVER['REQUEST_URI'], '/patreon-authorization/' ) !== false ) {
			// We are in Patreon login process. Do not interfere with login. We will deal with the Patreon user when the login happens
			
			return $username;
			
		}
		
		$user_patronage = Patreon_WordPress::getUserPatronage($user);
		
		if($user_patronage < $this->opt['content_locking']['only_patrons_with_amount']*100) {
	
			$message_1 = $this->lang['only_patrons_login_message_1'];			
			$message_2 = $this->lang['only_patrons_login_message_2'];

			// Check for vip and custom Patreon level users
			
			// Default the vip status
			$vip = 'no';
			
			$vip                = get_user_meta( $current_user->ID, 'cb_p6_a1_vip_user', true );
			$user_patreon_level = get_user_meta( $current_user->ID, 'cb_p6_a1_patreon_level', true );

			if ( $vip == 'yes' OR $user_patreon_level >= $patreon_level ) {
				// Vip user or custom level user. Allow login
				return $username;			
			}
				
			if(isset($this->opt['content_locking']['only_patrons_login_message_1']) AND
				$this->opt['content_locking']['only_patrons_login_message_1']!='') {
				
				$message_1 = $this->opt['content_locking']['only_patrons_login_message_1'];	
					
			}

			if(isset($this->opt['content_locking']['only_patrons_login_message_2']) AND
				$this->opt['content_locking']['only_patrons_login_message_2']!='') {
					
				$message_2 = $this->opt['content_locking']['only_patrons_login_message_2'];
					
			}
					
			$message = $message_1.$this->opt['content_locking']['only_patrons_with_amount'].$message_2;

			$redirect_url = wp_login_url();
			$redirect_url = add_query_arg( 'patreon_message', 'patreon_weird_redirection_at_login', $redirect_url);					
			$redirect_url = add_query_arg( 'patron_pro_override_error_message', urlencode($message), $redirect_url);
			
			wp_logout();
			wp_redirect($redirect_url);
			exit;
		}
		
		return $username;
		
	}
	public static function filter_patreon_messages_p($message)
	{
		if(isset($_REQUEST['patron_pro_override_error_message']) AND $_REQUEST['patron_pro_override_error_message']!='') {
			
			return urldecode($_REQUEST['patron_pro_override_error_message']);
		}
		return $message;
	}
	public function admin_notices_p() {
		$options = get_option('cb_p6_options',false);
		
		if ( isset( $options['lang'] ) ) {
			$active_lang=$options['lang'];
		}
		
		
		if(!isset($active_lang) OR !$active_lang OR $active_lang=='') {
			$active_lang='en-US';
		}
		$setup_notice_shown = false;

		if( ( !isset( $this->opt['setup_done'] ) OR !$this->opt['setup_done'] ) AND ( !isset( $_REQUEST['page'] ) OR $_REQUEST['page'] != 'setup_wizard_'.$this->internal['id'] ) ) {
			
			// Include language file:
			?>
				 <div class="error notice">
					<p><?php echo $this->lang['setup_not_complete']; ?></p>
				</div>
			<?php
			$setup_notice_shown = true;
		}
		
		if( $this->required_plugins() AND ( !isset( $_REQUEST['page'] ) OR $_REQUEST['page'] != 'setup_wizard_'.$this->internal['id'] ) AND !$setup_notice_shown ) {
			
			// Include language file:
			?>
				 <div class="error notice">
					<p><?php echo $this->lang['required_plugins_missing']; ?></p>
				</div>
			<?php		
		}
	}
	public static function static_notices()
	{
		$options = get_option('cb_p6_options',false);
		$active_lang=$options['lang'];
		if(!$active_lang OR $active_lang=='') {
			$active_lang='en-US';
		}
		
		
		if(!class_exists('Patreon_Wordpress') AND !$cb_p6->internal['setup_is_being_done']) {
			// Include language file:
			include_once('includes/languages/'.$active_lang.'.php');
			?>
				 <div class="error notice">
					<p><?php echo $lang['pat_wordpress_missing']; ?></p>
				</div>
			<?php
		}
		
			
	}
	public function lock_or_not_p( $result, $post_id, $declined, $user ) {

		// Just bail out if this is not the main query for content and no post id was given
		if ( !is_main_query() AND !$post_id ) {
			
			return array(
				'lock' => false,
				'reason' => 'no_post_id_no_main_query',
			);
			
		}
		
		$user                           = wp_get_current_user();
		$user_pledge_relationship_start = Patreon_Wordpress::get_user_pledge_relationship_start( $user );
		$user_patronage                 = Patreon_Wordpress::getUserPatronage( $user );
		$is_patron                      = Patreon_Wordpress::isPatron( $user );
		$user_lifetime_patronage        = Patreon_Wordpress::get_user_lifetime_patronage( $user );
		$declined                       = Patreon_Wordpress::checkDeclinedPatronage( $user );
		$vip                            = get_user_meta( $user->ID, 'cb_p6_a1_vip_user', true );
		$user_patreon_level             = get_user_meta( $user->ID, 'cb_p6_a1_patreon_level', true );
	
		$lock = false;
		// Assign incoming $result vars from lock or not to local vars
		if ( isset( $result['lock'] ) ) {
			$lock = $result['lock'];
		}
		
		$reason = '';
		// Assign incoming $result vars from lock or not to local vars
		if ( isset( $result['reason'] ) ) {
			$reason = $result['reason'];
		}
		
		$patreon_level = 0;
		// Assign incoming $result vars from lock or not to local vars
		if ( isset( $result['patreon_level'] ) ) {
			$patreon_level = $result['patreon_level'];
		}
				
		// If post it received, get that post. If no post id received, try to get post from global
		if ( $post_id ) {
			$post = get_post( $post_id );
		}
		else {
			global $post;
		}
		
		// Check if post was set for active patrons only
		$patreon_active_patrons_only = get_post_meta( $post->ID, 'patreon-active-patrons-only', true );
		
		// Check if specific total patronage is given for this post:
		$post_total_patronage_level = get_post_meta( $post->ID, 'patreon-total-patronage-level', true );		
		
		$post_type = get_post_type( $post->ID );	
		
		$post_level = get_post_meta( $post->ID, 'patreon-level', true );
		
		$marked = get_post_meta( $post->ID, 'marked_patron_only', true );
		
		$lock = false;
		
		$lock_by_post_type = false;
				
		// Check if this is a gated post type, and check wheter it is to be gated according to its condition

		if(isset($this->opt['content_locking']['gated_post_types'][$post_type])) {
			
			$taxonomies = $this->opt['content_locking']['gated_post_types'][$post_type];
			
			$post_taxonomies = get_post_taxonomies( $post );

			foreach( $taxonomies as $key_taxonomy => $value_taxonomy ) {
				
				if ( $key_taxonomy == 'all' ) {
					$lock_by_post_type = true;
					$lock_info = $this->opt['content_locking']['gated_post_types'][$post_type][$key_taxonomy]['all'];
				}
				else {
					
					// See if this taxonomy is assigned at all:
					
					if ( !in_array( $key_taxonomy, $post_taxonomies ) ) {
						// Not relevant. continue
						continue;
					}
					else {
						
					}
									
					$terms = $taxonomies[$key_taxonomy];
					
					foreach( $terms as $key_term => $value_term ) {
						
						if ( $key_term == 'all' ) {
							$lock_by_post_type = true;
							$lock_info = $this->opt['content_locking']['gated_post_types'][$post_type][$key_taxonomy]['all'];
						}
						else {
							
							$post_terms = wp_get_post_terms( $post_id, $key_taxonomy, array('orderby' => 'name', 'order' => 'ASC', 'fields' => 'slugs') );
														
							if ( is_wp_error( $post_terms ) ) {
								// couldnt get post terms. Dont do anything
								continue;
							}
							else {
								
								// Not wp error. process more.

								$term_match = false;
								
								if ( is_array( $post_terms ) AND count( $post_terms ) > 0 ) {

									// The post has classification from this taxonomy.
									
									foreach ( $post_terms as $post_key_term => $post_value_term ) {
										
										// Check if the selected taxonomy is in taxonomy terms of this post
				
										if ( $post_terms[$post_key_term] == $key_term ) {
											$term_match = true;
										}
									}
									
									// Now, if there is taxonomy match, check if it is all taxonomy items or one of them:
									
									if ( $term_match  ) {
										// Taxonomy item match or all taxonomy items are set to be locked. lock
										
										$lock_by_post_type = true;
										$lock_info = $terms[$key_term];
									}
									
								}
								else {
									// The post does not have classification from this taxonomy. Then it is not to be locked. Dont set the flag to true. Do nothing.

								}
								
							}
							
						}
						
					}
					
				}
			
			}
	
			// If the post is set to lock by post type, use the flag
			if ( $lock_by_post_type ) {

				if($lock_info['locking_type']=='all') {

					// All posts of this type are set locked.
					
					$patreon_level = $lock_info['locking_value'];
					$lock = true;
					$reason = 'ppp_all_posts_of_this_type_locked';
					
				}
				
				if($lock_info['locking_type']=='last_x') {
					// Last x method. Check if this is one of these last posts.
					
					$last_x = $lock_info['locking_variable'];
					
					$args = array(
						'numberposts' => (int)$last_x,
						'orderby' => 'ID',
						'order' => 'DESC',
						'post_type' => $post_type,
						'post_status' => 'publish',
						'suppress_filters' => true
					);
					// The above arguments will get last x posts by id, but only include this particular post if it is in that query set!
					$last_x_posts = wp_get_recent_posts( $args, ARRAY_A );	
				
					$found=false;
					if(isset($last_x_posts[0])) {
						
						foreach($last_x_posts as $key => $value) {
						
							// Iterate to check post ids
							if($last_x_posts[$key]['ID']==$post->ID) {
								
								$found = true;
							}
						}
						
						// If here, then this post is really one of the last x. Set patreon value to locked post type value
						if($found) {
							$patreon_level = $lock_info['locking_value'];
							$lock = true;
							$reason = 'ppp_last_x_posts_of_this_type_locked';
						}
						
					}
						
					
				}
				if($lock_info['locking_type']=='show_last_x') {
					
					// This time post will be locked if it is not one of the last x
					
					$last_x = $lock_info['locking_variable'];
					
					$args = array(
						'numberposts' => (int)$last_x,
						'orderby' => 'ID',
						'order' => 'DESC',
						'post_type' => $post_type,
						'post_status' => 'publish',
						'suppress_filters' => true
					);
					// The above arguments will get last x posts by id, but only include this particular post if it is in that query set!
					$last_x_posts = wp_get_recent_posts( $args, ARRAY_A );	
			
					$found=false;
					if(isset($last_x_posts[0])) {
						
						foreach($last_x_posts as $key => $value) {
						
							// Iterate to check post ids
							if($last_x_posts[$key]['ID']==$post->ID) {
								
								$found = true;
							}
						}
						
						// If here, then this post is really one of the last x. Set patreon value to locked post type value
						if(!$found) {
							$patreon_level = $lock_info['locking_value'];
							$lock = true;
							$reason = 'ppp_all_posts_except_last_x_of_this_type_locked';
						}
						
					}
					
				}
				if($lock_info['locking_type']=='age') {
					
					$age = $lock_info['locking_variable'];
			
					// check the age of the post in days :
					$today = date('r');
					$articledate = get_the_time('r');
					$post_age = round((strtotime($today) - strtotime($articledate))/(24*60*60),0);
								
					if($post_age >= $age) {
						$patreon_level = $lock_info['locking_value'];
						$lock = true;
						$reason = 'ppp_all_posts_of_this_type_locked_by_age';
					}
				
				}
				if($lock_info['locking_type']=='show_age') {
					
					$age = $lock_info['locking_variable'];
			
					// check the age of the post in days :
					$today = date('r');
					$articledate = get_the_time('r');
					$post_age = round((strtotime($today) - strtotime($articledate))/(24*60*60),0);
								
					if($post_age <= $age) {
						$patreon_level = $lock_info['locking_value'];
						$lock = true;
						$reason = 'ppp_all_posts_of_this_type_shown_by_age';
					}
				
				}
				if($lock_info['locking_type']=='date') {
					
					$start_day = $lock_info['start_date']['day'];
					$start_month = $lock_info['start_date']['month'];
					$start_year = $lock_info['start_date']['year'];
			
					$end_day = $lock_info['end_date']['day'];
					$end_month = $lock_info['end_date']['month'];
					$end_year = $lock_info['end_date']['year'];
					
					$start_date = $start_year.'-'.$start_month.'-'.$start_day ;
					$end_date = $end_year.'-'.$end_month.'-'.$end_day ;
			
					if($start_day == 'any' OR $start_month == 'any' OR $start_year == 'any') {
						$start_date = 'any';
					}
					if($end_day == 'any' OR $end_month == 'any' OR $end_year == 'any') {
						$end_date = 'any';
					}
					$articledate = get_the_time('r');
					
					$post_date = strtotime($articledate);
					
					if($start_date == 'any' AND $end_date =='any') {
						
						$patreon_level = $lock_info['locking_value'];
						$lock = true;
						$reason = 'ppp_all_posts_of_this_type_locked_by_date_any_any';
						
					}
					
					if($start_date == 'any' AND $end_date !='any') {
						
						if($post_date <= mktime(0,0,0,$end_month,$end_day,$end_year) ) {
							
							$patreon_level = $lock_info['locking_value'];
							$lock = true;
							$reason = 'ppp_all_posts_of_this_type_locked_by_date_any_end';
						}
						
					} 
					
					
					if($start_date != 'any' AND $end_date =='any') {
						
						if($post_date >= mktime(0,0,0,$start_month,$start_day,$start_year) ) {
							
							$patreon_level = $lock_info['locking_value'];
							$lock = true;
							$reason = 'ppp_all_posts_of_this_type_locked_by_date_start_any';
						}
						
					}
					if($start_date != 'any' AND $end_date !='any') {
						
						if($post_date >= mktime(0,0,0,$start_month,$start_day,$start_year) AND $post_date <= mktime(0,0,0,$end_month,$end_day,$end_year)) {
							
							$patreon_level = $lock_info['locking_value'];
							$lock = true;
							$reason = 'ppp_all_posts_of_this_type_locked_by_date_start_end';
						}
						
					}
					
				}
			
			}
			
		}
		
		// Now check if an advanced post locking option was put in for this post only:
		
		$advanced_lock = get_post_meta( $post->ID, 'ppp_advanced_post_locking', true );

		if($advanced_lock != '') {
			
			// Gated post type. get the method and check according to method
			
			if($advanced_lock=='age') {
				
				$age = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
				$lock_value = get_post_meta( $post->ID, 'ppp_advanced_post_locking_value', true );
		
				// check the age of the post in days :
				$today = date('r');
				$articledate = get_the_time('r');
				$post_age = round((strtotime($today) - strtotime($articledate))/(24*60*60),0);
							
				if($post_age >= $age) {
					$patreon_level = $lock_value;
					$lock = true;
					$reason = 'ppp_this_post_locked_by_age';
				}
				else {
					$patreon_level = 0;
					$lock = false;
				}
			
			}
			
			if($advanced_lock=='show_age') {

				$age = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
				$lock_value = get_post_meta( $post->ID, 'ppp_advanced_post_locking_value', true );
		
				// check the age of the post in days :
				$today = date('r');
				$articledate = get_the_time('r');
				$post_age = round((strtotime($today) - strtotime($articledate))/(24*60*60),0);

				if($post_age < $age) {
					$patreon_level = $lock_value;
					$lock = true;
					$reason = 'ppp_this_post_shown_by_age';
				}
				else {
					$patreon_level = 0;
					$lock = false;
				}
			
			}
			if($advanced_lock=='date') {
				
				$date = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
				$lock_value = get_post_meta( $post->ID, 'ppp_advanced_post_locking_value', true );

				if(((string) (int) $date === $date)
				&& ($date <= PHP_INT_MAX)
				&& ($date >= ~PHP_INT_MAX)) {
					
					if(time() >= $date) {
						
						$patreon_level = $lock_value;
						$lock = true;
						$reason = 'ppp_this_post_locked_by_date';
					}
					else {
						$patreon_level = 0;
						$lock = false;
					}
					
				}
				
			}
			
			if($advanced_lock=='show_date') {
				
				$date = get_post_meta( $post->ID, 'ppp_advanced_post_locking_info', true );
				$lock_value = get_post_meta( $post->ID, 'ppp_advanced_post_locking_value', true );
				
				if(((string) (int) $date === $date) 
				&& ($date <= PHP_INT_MAX)
				&& ($date >= ~PHP_INT_MAX)) {
					
					if(time() <= $date) {
						
						$patreon_level = $lock_value;
						$lock = true;
						$reason = 'ppp_this_post_shown_by_date';
					}
					else {
						$patreon_level = 0;
						$lock = false;
					}
					
				}
				
			}
			
		}
	
		if($post_level>0) {
			$lock = true;
		}
		if($marked) {
			$lock = true;
			$reason = 'ppp_post_marked_patron_only';
		}
		
		if($this->opt['content_locking']['entire_site_patron_only']=='yes') {
			$lock = true;
			$reason = 'ppp_entire_site_marked_patron_only';
		}
		
		// If patreon level is 0 but the post is marked patron only, make gate level 1:
		if($lock AND (!isset($patreon_level) OR $patreon_level==0))
		{
			$patreon_level = 1;
		}
		
		// If a specific level is set for the post, it becomes the level value :
		
		if($post_level>0 AND ($advanced_lock == '' OR !$advanced_lock) ) {
			$patreon_level = $post_level;
		}

		if($lock) {
	
			if ( !( $user_patronage == false
				|| $user_patronage < ( $patreon_level * 100 )
				|| $declined ) AND is_user_logged_in() ) {
					
				$lock = false;
				$reason = 'valid_patron';
		
				// Seems valid patron. Lets see if active patron option was set and the user fulfills it
				
				if ( $patreon_active_patrons_only == '1'
				AND $user_pledge_relationship_start >= strtotime( get_the_date( '', $post->ID ) ) ) {
					$lock = true;
					$reason = 'not_active_patron_at_post_date';
			
				}
				
			}

			if ( isset( $user_patreon_level ) AND (int) $user_patreon_level >= $patreon_level ) {
				
				// This user qualifies because s/he has a custom patreon level set in profile that meets the requirement
				
				$lock = false;
				$reason = 'user_custom_patreon_level_qualifies';
			
			}
			
			if ( $vip == 'yes' ) {
				
				// User is VIP! Allowed to see anything!

				$lock = false;
				$reason = 'user_is_vip';
		
			}
			
		}

		$modify_result = array(
			'lock'                         => $lock,
			'reason'                       => $reason,
			'patreon_level'                => $patreon_level,
			'post_total_patronage_level'   => $post_total_patronage_level,
			'patreon_active_patrons_only'  => $patreon_active_patrons_only,
			'user_is_patron'               => $is_patron,
			'user_active_pledge'           => $user_patronage,
			'user_total_historical_pledge' => $user_lifetime_patronage,
			'user_pledge_relationship_start' => $user_pledge_relationship_start,
			'declined' => $declined,
		);
	
		$result = $modify_result + $result;
		Patreon_WordPress::$lock_or_not = $result;

		return $result;
		
	}
	
	public function save_user_meta_p( $user_id ) {
	
		if ( !current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}
		
		$vip = false;
		
		if ( $_REQUEST['cb_p6_a1_vip_user'] == 'yes' ) {
			
			$vip = 'yes';
		}

		update_user_meta( $user_id, 'cb_p6_a1_vip_user', $vip );
		
		update_user_meta( $user_id, 'cb_p6_a1_patreon_level', $_REQUEST['cb_p6_a1_patreon_level'] );
			
	}
	public function add_user_meta_p( $user ) {
		

		if( current_user_can( 'manage_options' ) ) {
			
			$patreon_vip = get_user_meta( $user->ID, 'cb_p6_a1_vip_user', true );
			
			if( $patreon_vip == 'yes' ) {
			
				$patreon_vip_checked =" CHECKED";
			
			}			
			
			?>

			<table class="form-table">
				<tr>
					<th><label for="patreon_user"><?php echo $this->lang['vip_user_label']; ?></label></th>
					<td>
						Yes <input type="checkbox" name="cb_p6_a1_vip_user" id="cb_p6_a1_vip_user" value="yes"<?php echo $patreon_vip_checked; ?>><br /><br />
						<?php echo $this->lang['vip_user_description']; ?><br />
					</td>
				</tr>
			
			</table>
			
			<table class="form-table">
				<tr>
					<th><label for="patreon_user"><?php echo $this->lang['patreon_user_level_label']; ?></label></th>
					<td>
						$<input type="text" name="cb_p6_a1_patreon_level" id="cb_p6_a1_patreon_level" value="<?php echo get_user_meta( $user->ID, 'cb_p6_a1_patreon_level', true );; ?>" /><br /><br />
						<?php echo $this->lang['patreon_user_level_description']; ?><br />
					</td>
				</tr>
			
			</table>

			<?php

		}		
		
		
	
	}
	public function cb_p6_action_before_content_filters_p( $content ) {
		// Will check and see if the post is locked and a valid patron is viewing it. If so, will disable post button.
		
						
		if(in_array('get_the_excerpt', $GLOBALS['wp_current_filter']) OR 'post' !== get_post_type() OR !is_singular('post')) {
			
			return;
		
		}
		
		// Check if post is protected and a valid patron is seeing it:
		
		global $post;

		if ( isset( $post ) ) {
			$lock_or_not = Patreon_WordPress::lock_or_not( $post->id );

			if (   $lock_or_not['reason'] == 'patron_fulfills_total_historical_pledge_requirement' 
				OR $lock_or_not['reason'] == 'valid_patron'
				OR $lock_or_not['reason'] == 'show_to_admin_users'
				OR $lock_or_not['reason'] == 'user_custom_patreon_level_qualifies'
				OR $lock_or_not['reason'] == 'user_is_vip'
			) {
				
				// This is a valid patron. Set cb_p6 to not show the post button
				
				global $cb_p6;
				
				if ( isset ( $cb_p6->opt['post_button']['show_button_under_posts'] ) ) {

					// Preserve existing option 
					
					$this->internal['cb_p6_post_button_option_save'] = $cb_p6->opt['post_button']['show_button_under_posts'];
					
					$cb_p6->opt['post_button']['show_button_under_posts'] = 'no';
					
				}
				
			}
			
			
		}
	
	}
	public function cb_p6_action_after_content_filters_p( $content ) {
		
		global $cb_p6; 
		
		if ( isset( $this->internal['cb_p6_post_button_option_save'] ) ) {
			$cb_p6->opt['post_button']['show_button_under_posts'] = $this->internal['cb_p6_post_button_option_save'];
		}
		
	
	}
	public function filter_patreon_flow_link_pledge_level_p( $pledge_level, $send_post_id = false, $args = false ) {
		// Filters PW flow links to change the $ amount if necessary:

		if ( !$send_post_id ) {
			// No post id. do nothing for now since this may be a direct unlock. Return sent pledge level.
			return $pledge_level;
		}

		// Call the lock or not function again - through Patron Pro's filter, it will return the modified values to get the pledge level
		$result = Patreon_WordPress::lock_or_not( $send_post_id );

		if( isset( $result['patreon_level'] ) AND is_int( (int)$result['patreon_level'] ) ) {
			return $result['patreon_level'] * 100;
		}
		
		return $pledge_level;
		
	}
	public function add_admin_modal_p() {
		echo '<!-- Patron Plugin Pro Modal -->
			<div id="ppp_patron_only_dialog" class="ppp_modal" title="Make excerpt patron only">
			</div>';
	}
	public function get_taxonomies_for_post_type_p($input) {
	
		if ( !current_user_can( 'manage_options' ) ) {
			echo 'Sorry, you must be an admin user to do this';
			exit;
		}

		$options = '';
		$taxonomy_objects = get_object_taxonomies( $_REQUEST['cb_p6_a1_post_type'], 'objects' );

		foreach ( $taxonomy_objects as $key => $value ) {
		   $options .= '<option value="'.$key.'">'.$taxonomy_objects[$key]->label.'</option>';
		}
		echo $options;
		exit;
		
		
	}
	public function get_taxonomy_items_for_taxonomy_p($input) {

		if ( !current_user_can( 'manage_options' ) ) {
			echo 'Sorry, you must be an admin user to do this';
			exit;
		}
	
		$options = '';

	    $terms = get_terms( 
		   array(
			'taxonomy' => $_REQUEST['cb_p6_a1_taxonomy'],
			'hide_empty' => false,
			) 
		);

		foreach ( $terms as $key => $value ) {
		   $options .= '<option value="'.$terms[$key]->slug.'">'.$terms[$key]->name.'</option>';
		}
		echo $options;
		exit;
		
		
		
	}
	function check_after_update_actions_p() {
		// This function is intended to do after update actions by firing on init to allow checking for update actions.
		
		
		if ( !isset( $this->opt['1_3_0_options_update_done'] ) ) {
			
			// Existing options for new post category / tag locking has not been done. Process:
			
			if ( isset( $this->opt['content_locking']['gated_post_types'] ) AND
				is_array( $this->opt['content_locking']['gated_post_types'] ) AND
				count( $this->opt['content_locking']['gated_post_types'] ) > 0 ) {
					
					
					foreach ( $this->opt['content_locking']['gated_post_types'] as $key => $value ) {
						
						$existing_values = $this->opt['content_locking']['gated_post_types'][$key];
						
						unset( $this->opt['content_locking']['gated_post_types'][$key] );
						
						$this->opt['content_locking']['gated_post_types'][$key]['all']['all'] = $existing_values;			
						
					}
					
					
					$this->opt['1_3_0_options_update_done'] = 'yes';
					
					$this->update_opt();
					
				}
			
		}
		
		
	}
	function add_news_section_to_admin_p() {
		// Adds a news section fetched from remote api.
		
		echo '<div id="news_section" type="patron_plugin_pro"></div>';
		
		// Turn off notices so unset options wont do unnecessary notices
		
		error_reporting(E_ALL & ~E_NOTICE);
		
	}
	function fetch_remote_news_p() {
		// Fetches news from remote api.
		
		$api_params = array(
			'action' => 'get_news',
			'type' => $_REQUEST['cb_p6_a1_news_type'],
			'site' => base64_encode(get_site_url()),
			'item_name' => base64_encode($this->internal['plugin_name'])
			
		);
		
		$remote_url = 'https://news.codebard.com';
		
		$response = wp_remote_get( add_query_arg( $api_params, $remote_url ), array( 'timeout' => 15, 'sslverify' => false,'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url') ) );

		if ( is_wp_error( $response ) )
			echo '';
	
		echo wp_remote_retrieve_body( $response );
		exit;
	}
	function set_patron_only_excerpt_background_color_p() {
		// Fetches news from remote api.
	
		if ( isset( $_REQUEST['cb_p6_a1_color'] ) ) {
			
			
			$this->opt['content_locking']['patron_only_excerpt_background_color'] = $_REQUEST['cb_p6_a1_color'];
			$this->update_opt();
			
			
		}
		
		
		exit;
	}
	public function patron_test_shortcode_p($args,$output) {

		global $post;

		// This function gates excerpt in content based on shortcodes
		
		$output .= 'Extra added text';

		return do_shortcode($output);
		
	}
	
	
}


$cb_p6_a1 = cb_p6_a1_plugin::get_instance();

function cb_p6_a1_get()
{

	// This function allows any plugin to easily retieve this plugin object
	return cb_p6_a1_plugin::get_instance();

}