jQuery.noConflict(); // Reverts '$' variable back to other JS libraries

jQuery(document).ready(function($) {

	jQuery('body').on("click",'.cb_p6_a1_admin_toggle_button',function(e) {
		target_div = document.getElementById($(this).attr( 'target' ));
		jQuery(target_div).fadeToggle(1800);
	});
	
	if(document.getElementById("news_section") !== null) {
		// News section exists. We are in a relevant news section for the plugin. Fetch news and update.
		
		var news_section = document.getElementById("news_section");
		
		var news_type = jQuery(news_section).attr('type');
		
		jQuery.ajax({
			url: ajaxurl,
			type:"POST",
			dataType : 'html',
			cache: false,
			data: {
				action: 'cb_p6_a1_fetch_remote_news',
				cb_p6_a1_news_type: news_type,
			},
			success: function( response ) {
				jQuery(news_section).html(response);
			},
			complete: function( response ) {
			},
			error: function( response ) {
			},
			statusCode: {
			}
		});		
		
		
	}
	
	if (document.querySelector('.cb_p6_a1_color_field') !== null) {
		jQuery('.cb_p6_a1_color_field').wpColorPicker();
	}
	
	// We are updating this color option individually via ajax, because for some reason wpcolorpicker possibly does not update the value of the color field when the color picker is inside a div which was previously hidden
	jQuery(".wp-color-picker").wpColorPicker(
	  'option',
	  'change',
	  function(event, ui) {
		var color = ui.color.toString();

		if ( jQuery(this).attr('id') == 'cb_p6_a1_patron_only_excerpt_background_color' ) {
		
			jQuery.ajax({
				url: ajaxurl,
				type:"POST",
				dataType : 'html',
				cache: false,
				data: {
					action: 'cb_p6_a1_set_patron_only_excerpt_background_color',
					cb_p6_a1_color: color,
				},
				success: function( response ) {
				},
				complete: function( response ) {
				},
				error: function( response ) {
				},
				statusCode: {
				}
			});
		}
		
	  }
	);

	jQuery(".cb_p6_a1_toggle").click(function (e) {
		var cb_p6_a1_input_target = document.getElementById(jQuery(this).attr('target'));
        e.preventDefault();
		jQuery(cb_p6_a1_input_target).toggle('slow');
	});

	jQuery(".cb_p6_a1_toggle_admin_sections").on('click',function (e) {
		if (jQuery(e.target).hasClass('cb_p2_settiong_section_help_icon') ) return;
		jQuery('#footer-thankyou').remove();
		var cb_p6_a1_input_target = jQuery(this).next().filter('.cb_p6_a1_admin_section');
        e.preventDefault();
		if ( jQuery(this).find('span:first').hasClass('dashicons-arrow-down-alt2') ) {
			jQuery(this).find('span:first').removeClass('dashicons-arrow-down-alt2');
			jQuery(this).find('span:first').addClass('dashicons-arrow-up-alt2');
		}
		else if ( jQuery(this).find('span:first').hasClass('dashicons-arrow-up-alt2') ) {
			jQuery(this).find('span:first').removeClass('dashicons-arrow-up-alt2');
			jQuery(this).find('span:first').addClass('dashicons-arrow-down-alt2');
		}
		jQuery(cb_p6_a1_input_target).toggle('slow');
	});
	
	jQuery("#cb_p6_a1_post_locking_format_post").change(function (e) {
		
		var cb_p6_a1_locking_format_post_type = jQuery(this).val();
		var cb_p6_a1_input_target = jQuery('#cb_p6_a1_post_locking_format_taxonomy');
		var cb_p6_a1_general_error = 'Sorry - could not get the category list for this post type';
		
        e.preventDefault();
				
		jQuery('#cb_p6_a1_post_locking_format_taxonomy').hide('slow');
		jQuery('#cb_p6_a1_post_locking_format_taxonomy_item').hide('slow');
		jQuery('#cb_p6_a1_post_locking_format_option_toggle').hide('slow');
		jQuery(cb_p6_a1_input_target).html('Loading...');

		jQuery.ajax({
			url: ajaxurl,
			type:"POST",
			dataType : 'html',
			cache: false,
			data: {
				action: 'cb_p6_a1_get_taxonomies_for_post_type',
				cb_p6_a1_post_type: cb_p6_a1_locking_format_post_type,
			},
			success: function( response ) {
				if( response == '' ) {
					response = cb_p6_a1_general_error;
				}
				jQuery(cb_p6_a1_input_target).html('<option selected value="all">All</option>' + response);
			},
			complete: function( response ) {
				jQuery('#cb_p6_a1_post_locking_format_taxonomy').show('slow');
				jQuery('#cb_p6_a1_post_locking_format_option_toggle').show('slow');
			},
			error: function( response ) {
				if( response == '' ) {
					//White page - possibly an issue with the server/site caused an error during updates
					response = cb_p6_a1_general_error;
				}
				jQuery(cb_p6_a1_input_target).html(response);
			},
			statusCode: {
				500: function(error) {
					response = 'Sorry, a program error was encountered on WordPress side. (500 error)';
					jQuery(cb_p6_a1_input_target).html(response);
				}
			}
		});		
	});
	
	jQuery("#cb_p6_a1_post_locking_format_metabox_toggle").change(function (e) {
		var cb_p6_a1_locking_format = jQuery(this).val();
        e.preventDefault();
		jQuery('.cb_p6_a1_locking_format_selector').hide();
		jQuery('#cb_p6_a1_post_locking_value').hide();
		if(cb_p6_a1_locking_format!='none') {
			jQuery("#cb_p6_a1_post_locking_format_" + cb_p6_a1_locking_format).toggle('slow');
			jQuery('#cb_p6_a1_post_locking_value').toggle('slow');
				
		}
	});
	
	jQuery("#cb_p6_a1_post_locking_format_taxonomy").change(function (e) {
		
		var cb_p6_a1_locking_format_post_taxonomy = jQuery(this).val();
		var cb_p6_a1_input_target = jQuery('#cb_p6_a1_post_locking_format_taxonomy_item');
		var cb_p6_a1_general_error = 'Sorry - could not get the category list for this post type';
		
        e.preventDefault();
		
		jQuery('#cb_p6_a1_post_locking_format_taxonomy_item').hide('slow');
		jQuery('#cb_p6_a1_post_locking_format_option_toggle').hide('slow');
		
		if ( cb_p6_a1_locking_format_post_taxonomy == 'all' ) {
			jQuery('#cb_p6_a1_post_locking_format_option_toggle').show('slow');
			return;
		}

		jQuery.ajax({
			url: ajaxurl,
			type:"POST",
			dataType : 'html',
			cache: false,
			data: {
				action: 'cb_p6_a1_get_taxonomy_items_for_taxonomy',
				cb_p6_a1_taxonomy: cb_p6_a1_locking_format_post_taxonomy,
			},
			success: function( response ) {
				if( response == '' ) {
					response = cb_p6_a1_general_error;
				}
				// jQuery(cb_p6_a1_input_target).html('<option selected value="all">All</option>' + response);
				jQuery(cb_p6_a1_input_target).html('<option selected value="all">All</option>' + response);
			},
			complete: function( response ) {
				jQuery('#cb_p6_a1_post_locking_format_taxonomy_item').show('slow');
				jQuery('#cb_p6_a1_post_locking_format_option_toggle').show('slow');
			},
			error: function( response ) {
				if( response == '' ) {
					//White page - possibly an issue with the server/site caused an error during updates
					response = cb_p6_a1_general_error;
				}
				jQuery(cb_p6_a1_input_target).html(response);
			},
			statusCode: {
				500: function(error) {
					response = 'Sorry, a program error was encountered on WordPress side. (500 error)';
					jQuery(cb_p6_a1_input_target).html(response);
				}
			}
		});		
	});
	
	jQuery("#cb_p6_a1_post_locking_format_option_toggle").change(function (e) {
		var cb_p6_a1_locking_format = jQuery(this).val();
        e.preventDefault();
		jQuery('.cb_p6_a1_locking_format_selector').hide();
		jQuery('#cb_p6_a1_post_locking_value').hide();
		if(cb_p6_a1_locking_format!='none') {
			jQuery("#cb_p6_a1_post_locking_format_" + cb_p6_a1_locking_format).toggle('slow');
			jQuery('#cb_p6_a1_post_locking_value').toggle('slow');
				
		}
	});
	
	jQuery(document).on( 'click', '.cb_p6_a1_notice .notice-dismiss', function(e) {

	
		jQuery.ajax({
			url: ajaxurl,
			type:"POST",
			dataType : 'html',
			data: {
				action: 'cb_p6_a1_dismiss_admin_notice',
				notice_id: jQuery(this).parent().attr("id"),
				notice_type: jQuery(this).parent().attr("notice_type"),
			}
		});

	});
	
	jQuery(document).on('click', '.cb_p6_a1_file_upload', function(e) {

		var cb_p6_a1_input_target = jQuery(this);
        e.preventDefault();
        var image = wp.media({ 
            title: 'Upload Image',
            // mutiple: true if you want to upload multiple files at once
            multiple: false
        }).open()
        .on('select', function(e){
            // This will return the selected image from the Media Uploader, the result is an object
            var uploaded_image = image.state().get('selection').first();
            // We convert uploaded_image to a JSON object to make accessing it easier
            // Output to the console uploaded_image
            var image_url = uploaded_image.toJSON().url;
            // Let's assign the url value to the input field
             cb_p6_a1_input_target.val(image_url);
			 
        });
    });
	
	jQuery(document).on('click', '.cb_p6_a1_clear_prevfield', function(e) {
		e.preventDefault();
		
		jQuery(this).prev().val('');
	
	});

	jQuery(document).on('click', '#ppp_patron_only_excerpt_level_submit', function(e) {
		
		e.preventDefault();
		
		var source = jQuery('#ppp_patron_only_excerpt_level_input_source').attr('source');
		var content = jQuery('#ppp_patron_only_excerpt_to_be').html();
		var patreon_level = jQuery('#ppp_patron_only_excerpt_level_value').val();
		
		var silent = 'no';
		
		if ( jQuery('#ppp_patron_only_excerpt_silent_checkbox').is(":checked") ) {
			var silent = 'yes';
		}
		
		// Slapschatt!!!
		
		wrapped_content = '[ppp_patron_only level="' + patreon_level + '" silent="' + silent + '"]' + content + '[/ppp_patron_only]'
		
		if ( source == 'visual' ) {
			
			tinymce.execCommand('mceInsertContent', false, wrapped_content);
		}
		
		if ( source == 'text' ) {
			
			QTags.insertContent(wrapped_content);
						
		}

		jQuery('#ppp_patron_only_dialog' ).html('Patron-only excerpt added/updated!');
		
		setTimeout(function(){
			jQuery('#ppp_patron_only_dialog').fadeTo('slow', 0, function() {
				jQuery('#ppp_patron_only_dialog').dialog('close');
			});
		}, 2000);
		
	
	});

	jQuery(document).on( 'submit', '#cb_p6_a1_ajax_plugin_install_form', function(e) {
		
        e.preventDefault();
		
		var cb_p6_a1_input_target = document.getElementById(jQuery(this).attr('ajax_target_div'));
		
		jQuery('#cb_p6_a1_ajax_plugin_install_form').remove();

		jQuery(cb_p6_a1_input_target).empty();
		jQuery(cb_p6_a1_input_target).html('Processing...');	

		var cb_p6_a1_general_error = '<h4>Sorry - something on your site or server is preventing automatic installation/update of the plugins. You may have to delete existing ones (if you have already installed them before), and upload/activate new ones from your <a href="https://codebard.com/your-codebard-account" target="_blank">CodeBard account</a>. You will not need to reconfigure your plugins and you will not lose your settings if you choose to do that..</h4>';		
		
		jQuery.ajax({
			url: ajaxurl,
			type:"POST",
			dataType : 'html',
			data: {
				action: 'cb_p6_a1_install_update_plugins',
			},
			success: function( response ) {
				jQuery(cb_p6_a1_input_target).empty();
				if( response == '' ) {
					//White page - possibly an issue with the server/site caused an error during updates
					response = cb_p6_a1_general_error;
				}
				jQuery(cb_p6_a1_input_target).html(response);
			},
			error: function( response ) {
				if( response == '' ) {
					//White page - possibly an issue with the server/site caused an error during updates
					response = cb_p6_a1_general_error;
				}
				jQuery(cb_p6_a1_input_target).empty();
				jQuery(cb_p6_a1_input_target).html(response);
			},
			statusCode: {
				500: function(error) {
					response = cb_p6_a1_general_error;
					jQuery(cb_p6_a1_input_target).empty();
					jQuery(cb_p6_a1_input_target).html(response);
				}
			}
		});
		
	});

	
});